/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui;

import cd4017be.lib.Gui.HidableSlot;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FileBrowser;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.InfoTab;
import cd4017be.lib.Gui.comp.Progressbar;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.Gui.comp.Tooltip;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.Main;
import cd4017be.rs_ctr.circuit.CircuitCompiler;
import cd4017be.rs_ctr.circuit.CompiledCircuit;
import cd4017be.rs_ctr.circuit.editor.CircuitInstructionSet;
import cd4017be.rs_ctr.gui.GuiDebugger;
import cd4017be.rs_ctr.gui.GuiErrorMarker;
import cd4017be.rs_ctr.tileentity.Assembler;
import cd4017be.rs_ctr.tileentity.Editor;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.editor.InvalidSchematicException;
import cd4017be.rscpl.gui.GatePalette;
import cd4017be.rscpl.gui.ISpecialCfg;
import cd4017be.rscpl.gui.SchematicBoard;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class CircuitEditor
extends ModularGui {
    private static final File dir = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics");
    private static final int FILE_MAGIC = 1075301120;
    private static final ResourceLocation BG_TEX = new ResourceLocation("rs_ctr", "textures/gui/editor.png");
    private static final ResourceLocation COMP_TEX = new ResourceLocation("rs_ctr", "textures/gui/palette.png");
    public final Editor tile;
    public final SchematicBoard board;
    public final GatePalette palette;
    public final GuiFrame cfg;
    public final GuiErrorMarker error;
    private GuiDebugger debug;

    public CircuitEditor(Editor tile, EntityPlayer player) {
        super(tile.getContainer(player, 0));
        this.tile = tile;
        GuiFrame comps = new GuiFrame((ModularGui)this, 256, 256, 17).background(BG_TEX, 0, 0).title(tile.getName(), 0.1f);
        comps.texture(COMP_TEX, 256, 256);
        new InfoTab((GuiCompGroup)comps, 7, 8, 7, 6, "gui.rs_ctr.editor.info");
        new TextField((GuiCompGroup)comps, 120, 8, 128, 4, 64, () -> tile.name, name -> {
            this.sendPkt(new Object[]{(byte)-5, name});
            tile.lastFile = null;
        }).tooltip("gui.rs_ctr.editor.title");
        this.cfg = new GuiFrame(comps, 76, 27, 2);
        this.cfg.position(173, 173);
        this.board = new SchematicBoard(comps, 8, 16, tile.schematic, this::changeSelPart);
        this.palette = new GatePalette(comps, CircuitInstructionSet.TABS, 7, 173, this.board::place){

            @Override
            protected String getTooltip(GateType t) {
                int cost = CircuitInstructionSet.INS_SET.getCost(t);
                return super.getTooltip(t) + "\n" + TooltipUtil.format((String)"gate.cost", (Object[])new Object[]{cost & 0xFF, cost >> 8 & 0xFF});
            }
        };
        this.palette.title("gui.rs_ctr.palette", 0.5f);
        new Button((GuiCompGroup)comps, 7, 7, 162, 162, 0, () -> this.board.selPart != null ? 1 : 0, this.board::del).texture(186, 0).tooltip("gui.rs_ctr.editor.del");
        new Button((GuiCompGroup)comps, 16, 14, 8, 158, 2, () -> this.palette.enabled() ? 1 : 0, this::togglePalette).texture(162, 52).tooltip("gui.rs_ctr.palette.open#");
        new Button((GuiCompGroup)comps, 16, 16, 232, 210, 0, null, i -> {
            tile.lastFile = null;
            this.sendCommand(-1);
        }).tooltip("gui.rs_ctr.editor.new");
        new Button((GuiCompGroup)comps, 16, 16, 214, 210, 0, null, b -> this.selFile(false)).tooltip("gui.rs_ctr.editor.load");
        new Button((GuiCompGroup)comps, 16, 16, 196, 210, 0, null, b -> {
            if (b == 1 || tile.lastFile == null) {
                this.selFile(true);
            } else {
                this.save(tile.lastFile);
            }
        }).tooltip("gui.rs_ctr.editor.save");
        new Button((GuiCompGroup)comps, 16, 16, 174, 210, 0, null, this::compile).tooltip("gui.rs_ctr.editor.compile");
        new Progressbar((GuiCompGroup)comps, 56, 4, 192, 232, 200, 0, -2, () -> this.tile.ingreds[0], 0.0, 112.0);
        new Progressbar((GuiCompGroup)comps, 56, 4, 192, 238, 200, 6, -2, () -> this.tile.ingreds[1], 0.0, 112.0);
        new Progressbar((GuiCompGroup)comps, 56, 4, 192, 244, 200, 12, -2, () -> this.tile.ingreds[2], 0.0, 112.0);
        new Progressbar((GuiCompGroup)comps, 56, 2, 192, 233, 200, 4, 4, () -> this.tile.ingreds[3], 0.0, 112.0);
        new Progressbar((GuiCompGroup)comps, 56, 2, 192, 239, 200, 10, 4, () -> this.tile.ingreds[4], 0.0, 112.0);
        new Progressbar((GuiCompGroup)comps, 56, 2, 192, 245, 200, 16, 4, () -> this.tile.ingreds[5], 0.0, 112.0);
        new Tooltip((GuiCompGroup)comps, 56, 16, 192, 232, "gui.rs_ctr.editor.ingreds", () -> new Object[]{this.tile.ingreds[3], this.tile.ingreds[0], this.tile.ingreds[4], this.tile.ingreds[1], this.tile.ingreds[5], this.tile.ingreds[2]});
        Assembler ass = tile.getAssembler();
        if (ass != null) {
            new Button((GuiCompGroup)comps, 10, 9, 177, 200, 0, () -> 0, b -> this.sendCommand(-6)).texture(168, 89).tooltip("gui.rs_ctr.to_assembler");
        }
        this.compGroup = comps;
        this.error = new GuiErrorMarker(this);
        this.palette.setEnabled(false);
        this.changeSelPart();
        this.togglePalette(0);
    }

    void togglePalette(int s) {
        boolean hide = !this.palette.enabled();
        this.palette.setEnabled(hide);
        for (Slot slot : this.field_147002_h.field_75151_b) {
            if (!(slot instanceof HidableSlot)) continue;
            ((HidableSlot)slot).hideSlot(hide);
        }
        this.drawInvTitle = !hide;
    }

    void changeSelPart() {
        this.cfg.clear();
        this.cfg.titleY = -11;
        BoundingBox2D<Gate> part = this.board.selPart;
        if (part != null && part.owner != null) {
            Gate g = (Gate)part.owner;
            this.cfg.background(COMP_TEX, 180, 36).title("gate." + g.type.name.replace(':', '.'), 0.5f);
            String s = this.cfg.title;
            int i = s.indexOf(10);
            if (i >= 0) {
                s = s.substring(0, i);
            }
            if (this.field_146289_q.func_78256_a(s) > this.cfg.w) {
                s = this.field_146289_q.func_78269_a(s, this.cfg.w - this.field_146289_q.func_78256_a("..")) + "..";
            }
            this.cfg.title = s;
            new TextField((GuiCompGroup)this.cfg, 74, 7, 1, 1, 20, () -> g.label, this::sendLabel).tooltip("gui.rs_ctr.opLabel");
            if (g instanceof ISpecialCfg) {
                ((ISpecialCfg)((Object)g)).setupCfgGUI(this.cfg, this::updateCfg);
            }
            this.cfg.init(this.cfg.screenWidth, this.cfg.screenHeight, this.cfg.zLevel, this.field_146289_q);
        } else {
            this.cfg.bgTexture = null;
            this.cfg.title = null;
            this.tile.ingreds[6] = 0;
        }
    }

    private void selFile(boolean save) {
        if (save) {
            dir.mkdirs();
        }
        GuiFrame fb = new FileBrowser((GuiFrame)this.compGroup, f -> {
            f.close();
            if (save) {
                this.save(f.getFile());
            } else {
                this.load(f.getFile());
            }
        }, fn -> fn.endsWith(".cb")).setFile(new File(dir, this.tile.name + ".cb").getAbsoluteFile()).title(save ? "gui.rs_ctr.save_file" : "gui.rs_ctr.load_file", 0.5f);
        fb.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
        fb.position(8, 8);
    }

    void load(File file) {
        try {
            int i;
            PacketBuffer data = GuiNetworkHandler.preparePacket((Container)this.container);
            data.writeByte(-2);
            int p = data.writerIndex();
            FileInputStream fis = new FileInputStream(file);
            while ((i = fis.available()) > 0) {
                data.writeBytes((InputStream)fis, i);
            }
            fis.close();
            if (data.getInt(p) != 1075301120) {
                this.sendChat(TooltipUtil.translate((String)"msg.rs_ctr.invalid_file"));
            }
            this.tile.lastFile = file;
            GuiNetworkHandler.GNH_INSTANCE.sendToServer(data);
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr.no_file", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            this.sendChat("\u00a74" + e.toString());
        }
    }

    void save(File file) {
        try {
            ByteBuf data = Unpooled.buffer();
            data.writeInt(1075301120);
            int i = data.writerIndex();
            data.writeByte(0);
            data.setByte(i, data.writeCharSequence((CharSequence)this.tile.name, Utils.UTF8));
            this.tile.schematic.serialize(data);
            file.createNewFile();
            FileOutputStream fos = new FileOutputStream(file);
            data.readBytes((OutputStream)fos, data.writerIndex());
            fos.close();
            this.tile.lastFile = file;
            this.sendChat(TooltipUtil.translate((String)"msg.rs_ctr.save_succ"));
        }
        catch (Exception e) {
            this.sendChat("\u00a74" + e.toString());
        }
    }

    void compile(int b) {
        if (b == 1) {
            this.compGroup.remove((Object)this.debug);
            try {
                this.tile.ingreds[6] = 0;
                CompiledCircuit cc = (CompiledCircuit)CircuitCompiler.INSTANCE.compile(this.tile.schematic.operators);
                if (cc.compileWarning != null) {
                    this.tile.ingreds[6] = cc.compileWarning.compact();
                }
                this.debug = new GuiDebugger((GuiFrame)this.compGroup, cc);
                this.debug.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
                this.debug.position(8, 8);
            }
            catch (InvalidSchematicException e) {
                this.tile.ingreds[6] = e.compact();
            }
            catch (Throwable e) {
                Main.LOG.error("internal compilation error: ", e);
            }
        } else if (b == 0) {
            this.sendCommand(-4);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.board.update();
        this.error.update(this.tile.ingreds[6]);
        if (this.debug != null) {
            this.debug.update();
        }
    }

    public void sendLabel(String label) {
        BoundingBox2D<Gate> part = this.board.selPart;
        PacketBuffer pkt = GuiNetworkHandler.preparePacket((Container)this.container);
        pkt.writeByte(4).writeByte(((Gate)part.owner).index);
        pkt.writeCharSequence((CharSequence)label, Utils.UTF8);
        GuiNetworkHandler.GNH_INSTANCE.sendToServer(pkt);
    }

    public void updateCfg() {
        BoundingBox2D<Gate> part = this.board.selPart;
        if (part == null || part.owner == null) {
            return;
        }
        PacketBuffer pkt = GuiNetworkHandler.preparePacket((Container)this.container);
        pkt.writeByte(5).writeByte(((Gate)part.owner).index);
        if (((Gate)part.owner).writeCfg((ByteBuf)pkt)) {
            GuiNetworkHandler.GNH_INSTANCE.sendToServer(pkt);
        }
    }
}

