/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui;

import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.FileBrowser;
import cd4017be.lib.Gui.comp.FormatText;
import cd4017be.lib.Gui.comp.GuiCompBase;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.ramio.RAMImageFormat;
import cd4017be.rs_ctr.tileentity.RAM;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class GuiRAM
extends ModularGui {
    private static final ResourceLocation TEX = new ResourceLocation("rs_ctr", "textures/gui/ram.png");
    private static final File dir = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics/data");
    private final RAM tile;
    private int fmtW;
    private int fmtH;

    public GuiRAM(RAM tile, EntityPlayer player) {
        super(tile.getContainer(player, 0));
        this.tile = tile;
        GuiFrame frame = new GuiFrame((ModularGui)this, 160, 144, 6).background(TEX, 0, 0).title("gui.rs_ctr.ram.name", 0.5f);
        new FormatText((GuiCompGroup)frame, 64, 7, 8, 16, "\\0x%08X", () -> new Object[]{tile.writeIN}).align(0.5f).color(-16777089);
        new FormatText((GuiCompGroup)frame, 64, 7, 88, 16, "\\0x%08X", () -> new Object[]{tile.readIN}).align(0.5f).color(-16744704);
        new Editor((GuiCompGroup)frame, 144, 102, 8, 25);
        new Button((GuiCompGroup)frame, 18, 9, 7, 128, 0, null, i -> {
            File file = new File(Minecraft.func_71410_x().field_71412_D, "circuitSchematics/data").getAbsoluteFile();
            file.mkdirs();
            file = new File(file, "ram.hex");
            GuiFrame fb = new FileBrowser(frame, this::importData, null).setFile(file).title("gui.rs_ctr.import_file", 0.5f);
            fb.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
            fb.position(8, 8);
        }).tooltip("gui.rs_ctr.import_file");
        new Button((GuiCompGroup)frame, 18, 9, 25, 128, 0, null, i -> this.sendPkt(new Object[]{(byte)3})).tooltip("gui.rs_ctr.export_file");
        new TextField((GuiCompGroup)frame, 48, 7, 54, 129, 8, () -> Integer.toString(this.fmtW), t -> {
            try {
                this.fmtW = Integer.parseInt(t);
                if (this.fmtW <= 0) {
                    this.fmtW = 1;
                } else if (this.fmtW > 4096) {
                    this.fmtW = 4096;
                }
                this.fmtH = Math.max(1, Math.min(4096, (tile.addrMask + 1) / this.fmtW));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.fmt_w");
        new TextField((GuiCompGroup)frame, 48, 7, 104, 129, 8, () -> Integer.toString(this.fmtH), t -> {
            try {
                this.fmtH = Integer.parseInt(t);
                if (this.fmtH <= 0) {
                    this.fmtH = 1;
                } else if (this.fmtH > 4096) {
                    this.fmtH = 4096;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.fmt_h");
        this.compGroup = frame;
        this.fmtW = 16;
        this.fmtH = tile.addrMask + 1 >> 4;
    }

    public void processDownload(byte[] mem) {
        ByteBuffer data = ByteBuffer.wrap(mem);
        File file = dir.getAbsoluteFile();
        file.mkdirs();
        file = new File(file, "ram.hex");
        GuiFrame f = new FileBrowser((GuiFrame)this.compGroup, fb -> {
            fb.close();
            this.exportData(fb.getFile(), data);
        }, null).setFile(file).title("gui.rs_ctr.export_file", 0.5f);
        f.init(this.field_146294_l, this.field_146295_m, this.field_73735_i, this.field_146289_q);
        f.position(8, 8);
    }

    private void exportData(File file, ByteBuffer data) {
        if (!file.getAbsolutePath().startsWith(dir.getAbsolutePath())) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr.dir_invalid", (Object[])new Object[]{file}));
            return;
        }
        String name = file.getName();
        RAMImageFormat fmt = RAMImageFormat.get(name);
        try (FileOutputStream fos = new FileOutputStream(file);){
            int bits = 1 << 5 - (this.tile.mode & 3);
            this.sendChat(fmt.infoMessage(true, name, this.fmtW, this.fmtH, bits));
            fmt.exportFile(fos, data, this.fmtW, this.fmtH, bits);
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr.no_file", (Object[])new Object[]{file}));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendChat("\u00a74" + e.toString());
            return;
        }
        this.sendChat(TooltipUtil.format((String)"msg.rs_ctr.export_succ", (Object[])new Object[0]));
    }

    private void importData(FileBrowser fb) {
        fb.close();
        File file = fb.getFile();
        String name = file.getName();
        RAMImageFormat fmt = RAMImageFormat.get(name);
        try (FileInputStream fis = new FileInputStream(file);){
            int bits = 1 << 5 - (this.tile.mode & 3);
            this.sendChat(fmt.infoMessage(false, name, this.fmtW, this.fmtH, bits));
            PacketBuffer buff = GuiNetworkHandler.preparePacket((Container)this.container);
            buff.writeByte(4);
            int[] wh = new int[]{this.fmtW, this.fmtH};
            fmt.importFile(fis, buff, wh, bits, this.tile.memSize());
            this.fmtW = wh[0];
            this.fmtH = wh[1];
            GuiNetworkHandler.GNH_INSTANCE.sendToServer(buff);
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr.no_file", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendChat("\u00a74" + e.toString());
        }
    }

    class Editor
    extends GuiCompBase<GuiCompGroup> {
        int cursor;

        public Editor(GuiCompGroup parent, int w, int h, int x, int y) {
            super(parent, w, h, x, y);
            this.cursor = -1;
        }

        public void drawOverlay(int mx, int my) {
            if (my - this.y > 6) {
                return;
            }
            GuiRAM.this.compGroup.drawTooltip(TooltipUtil.format((String)"gui.rs_ctr.ram.layout", (Object[])new Object[]{32 >> (((GuiRAM)GuiRAM.this).tile.mode & 3), ((GuiRAM)GuiRAM.this).tile.addrMask + 1}), mx, my);
        }

        public void drawBackground(int mx, int my, float t) {
            int bits = ((GuiRAM)GuiRAM.this).tile.mode & 3;
            GuiRAM.this.compGroup.drawRect(this.x, this.y, 0, 232 + bits * 6, 128, 6);
            this.print(128, 0, ((GuiRAM)GuiRAM.this).tile.addrMask, 4, 4);
            int addr = ((GuiRAM)GuiRAM.this).tile.page << bits + 6;
            int l = (Math.min(64, GuiRAM.this.tile.memSize() + 3) >> 2) * 6;
            int j = 0;
            for (int i = 6; i <= l; i += 6) {
                this.print(128, i, addr + j, 4, 5);
                int k = (4 << bits) - 1;
                while (k >= 0) {
                    this.print(k << 5 - bits, i, j <= ((GuiRAM)GuiRAM.this).tile.addrMask ? GuiRAM.this.tile.get(j) : 0, 8 >> bits, (addr + j == ((GuiRAM)GuiRAM.this).tile.readIN ? 2 : 0) | (addr + j == ((GuiRAM)GuiRAM.this).tile.writeIN ? 1 : 0));
                    --k;
                    ++j;
                }
            }
            if (this.cursor >= 0) {
                int y = this.y + 6 + (this.cursor >> 5) * 6;
                int x = this.x + 124 - (this.cursor & 0x1F) * 4;
                int v = (((GuiRAM)GuiRAM.this).tile.memory[this.cursor >> 3 & 0x3F] >> (this.cursor << 2 & 0x1C) & 0xF) * 8;
                if ((this.cursor & 7 >> bits) == 0) {
                    v += 4;
                }
                GuiRAM.this.compGroup.drawRect(x, y, v, 190, 4, 6);
            }
        }

        private void print(int x, int y, int v, int w, int c) {
            c = 196 + c * 6;
            GuiRAM.this.compGroup.drawRect(x += this.x + 4 * (w - 1), y += this.y, (v & 0xF) * 8 + 4, c, 4, 6);
            --w;
            while (w > 0) {
                GuiRAM.this.compGroup.drawRect(x -= 4, y, ((v >>= 4) & 0xF) * 8, c, 4, 6);
                --w;
            }
        }

        public boolean keyIn(char c, int k, byte d) {
            byte v;
            switch (k) {
                case 200: {
                    this.cursor -= 31;
                }
                case 205: {
                    if (--this.cursor < 0) {
                        int n = this.cursor = this.mvPage(-1) ? this.cursor + 512 : 0;
                    }
                    if (GuiScreen.func_146272_n()) {
                        this.cursor &= ~(7 >> (((GuiRAM)GuiRAM.this).tile.mode & 3));
                    }
                    return true;
                }
                case 208: {
                    this.cursor += 31;
                }
                case 203: {
                    if (GuiScreen.func_146272_n()) {
                        this.cursor |= 7 >> (((GuiRAM)GuiRAM.this).tile.mode & 3);
                    }
                    if (++this.cursor > 511) {
                        this.cursor = this.mvPage(1) ? this.cursor - 512 : 511;
                    }
                    return true;
                }
                case 201: {
                    this.mvPage(-1);
                    return true;
                }
                case 209: {
                    this.mvPage(1);
                    return true;
                }
                case 199: {
                    this.cursor = 0;
                    GuiRAM.this.sendPkt(new Object[]{(byte)1, (byte)0});
                    return true;
                }
                case 207: {
                    this.cursor = 511;
                    GuiRAM.this.sendPkt(new Object[]{(byte)1, (byte)127});
                    return true;
                }
                case 11: {
                    v = 0;
                    break;
                }
                case 2: {
                    v = 1;
                    break;
                }
                case 3: {
                    v = 2;
                    break;
                }
                case 4: {
                    v = 3;
                    break;
                }
                case 5: {
                    v = 4;
                    break;
                }
                case 6: {
                    v = 5;
                    break;
                }
                case 7: {
                    v = 6;
                    break;
                }
                case 8: {
                    v = 7;
                    break;
                }
                case 9: {
                    v = 8;
                    break;
                }
                case 10: {
                    v = 9;
                    break;
                }
                case 30: {
                    v = 10;
                    break;
                }
                case 48: {
                    v = 11;
                    break;
                }
                case 46: {
                    v = 12;
                    break;
                }
                case 32: {
                    v = 13;
                    break;
                }
                case 18: {
                    v = 14;
                    break;
                }
                case 33: {
                    v = 15;
                    break;
                }
                default: {
                    return false;
                }
            }
            GuiRAM.this.sendPkt(new Object[]{(byte)2, (short)(this.cursor | ((GuiRAM)GuiRAM.this).tile.page << 9), v});
            if (GuiScreen.func_146271_m()) {
                this.cursor += 31;
            }
            if (++this.cursor > 511) {
                this.cursor = this.mvPage(1) ? this.cursor - 512 : 511;
            }
            return true;
        }

        public boolean mouseIn(int mx, int my, int b, byte d) {
            mx = 31 - (mx - this.x) / 4;
            my = (my - this.y) / 6 - 1;
            if (d == 0) {
                if (my < 0) {
                    GuiRAM.this.sendPkt(new Object[]{(byte)0, (byte)(((GuiRAM)GuiRAM.this).tile.mode + (b == 0 ? 1 : 3))});
                }
                this.cursor = my * 32 + (mx < 0 ? 0 : mx);
            } else if (d == 3) {
                this.mvPage(-b);
            }
            return true;
        }

        private boolean mvPage(int incr) {
            if ((incr += ((GuiRAM)GuiRAM.this).tile.page) < 0 || incr >= 1 << (((GuiRAM)GuiRAM.this).tile.mode >> 4 & 0xF) - 6) {
                return false;
            }
            GuiRAM.this.sendPkt(new Object[]{(byte)1, (byte)incr});
            return true;
        }

        public boolean focus() {
            return true;
        }

        public void unfocus() {
            this.cursor = -1;
        }
    }
}

