/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.gui.ramio;

import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.ramio.RAMImageFormat;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.PacketBuffer;

public final class IntelHex
implements RAMImageFormat {
    public IntelHex() {
        REGISTRY.add(this);
    }

    @Override
    public boolean applies(String filename) {
        return filename.endsWith(".hex");
    }

    @Override
    public String infoMessage(boolean export, String file, int w, int h, int bits) {
        return TooltipUtil.format((String)(export ? "msg.rs_ctr.encode_hex" : "msg.rs_ctr.decode_hex"), (Object[])new Object[]{file});
    }

    @Override
    public void importFile(FileInputStream fis, PacketBuffer data, int[] wh, int bits, int cap) throws IOException {
        int d;
        ByteBuffer buff = ByteBuffer.allocate(cap << 2);
        block4: while ((d = fis.read()) >= 0) {
            if (d != 58) continue;
            int addr = this.readHexDigits(fis, 4);
            switch (this.readHexDigits(fis, 2)) {
                case 0: {
                    int n;
                    buff.position(addr);
                    for (n = this.readHexDigits(fis, 2); n >= 4; n -= 4) {
                        buff.putInt(this.readHexDigits(fis, 8));
                    }
                    while (n > 0) {
                        buff.put((byte)this.readHexDigits(fis, 2));
                        --n;
                    }
                    continue block4;
                }
                case 1: {
                    return;
                }
            }
            throw new IOException();
        }
        buff.clear();
        data.writeBytes(buff);
    }

    private int readHexDigits(InputStream is, int n) throws IOException {
        int r = 0;
        while (--n >= 0) {
            int d = is.read();
            if (d < 0) {
                throw new EOFException();
            }
            if ((d = Character.digit(d, 16)) < 0) {
                throw new NumberFormatException();
            }
            r = r << 4 | d;
        }
        return r;
    }

    @Override
    public void exportFile(FileOutputStream fos, ByteBuffer data, int w, int h, int bits) throws IOException {
        int n;
        if (w > 255) {
            w = 255;
        }
        block0: while ((n = data.remaining()) > 0) {
            if (n > w) {
                n = w;
            }
            data.mark();
            for (int i = n; i > 0; --i) {
                if (data.get() == 0) {
                    continue;
                }
                data.reset();
                fos.write(58);
                this.writeHexByte(fos, n);
                this.writeHexByte(fos, data.position() >> 8);
                this.writeHexByte(fos, data.position());
                this.writeHexByte(fos, 0);
                while (n > 0) {
                    this.writeHexByte(fos, data.get());
                    --n;
                }
                fos.write(10);
                continue block0;
            }
        }
        fos.write(":00000001\n".getBytes(StandardCharsets.US_ASCII));
    }

    private void writeHexByte(OutputStream os, int v) throws IOException {
        os.write(Character.forDigit(v >> 4 & 0xF, 16));
        os.write(Character.forDigit(v & 0xF, 16));
    }
}

