/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ItemInteractionHandler;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.Spinner;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerItem;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.item.ItemPanelModule;
import cd4017be.rs_ctr.port.Clock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemClock
extends ItemPanelModule
implements Connector.IConnectorItem,
IGuiHandlerItem {
    public ItemClock(String id) {
        super(id, "clock");
    }

    public void doAttach(ItemStack stack, MountedPort port, EntityPlayer player) {
        if (port.type != SignalHandler.class) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.type", new Object[0]));
            return;
        }
        if (port.isMaster) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.dir_in", new Object[0]));
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return;
        }
        Clock c = new Clock(port);
        c.deserializeNBT(nbt);
        port.setConnector((Connector)c, player);
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            stack.func_77982_d(null);
        } else {
            if (!stack.func_77942_o()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("int", 20);
                stack.func_77982_d(nbt);
            }
            GuiNetworkHandler.openHeldItemGui((EntityPlayer)player, (EnumHand)hand, (int)0, (int)0, (int)0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public AdvancedContainer getContainer(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        return new StateInteractionHandler(slot).createContainer(player);
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getGuiScreen(ItemStack stack, EntityPlayer player, int slot, int x, int y, int z) {
        StateInteractionHandler state = new StateInteractionHandler(slot);
        ModularGui gui = new ModularGui(state.createContainer(player));
        GuiFrame frame = new GuiFrame(gui, 80, 58, 2).title("gui.rs_ctr.clock.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 0, 31);
        new Spinner((GuiCompGroup)frame, 36, 18, 37, 15, false, "\\%+.2fs", () -> (double)state.phase / 20.0, v -> gui.sendPkt(new Object[]{(byte)1, (int)Math.round(v * 20.0)}), -60.0, 60.0, new double[]{1.0, 0.05}).tooltip("gui.rs_ctr.phase");
        new Spinner((GuiCompGroup)frame, 36, 18, 37, 33, false, "\\%.2fs", () -> (double)state.interval / 20.0, v -> gui.sendPkt(new Object[]{(byte)0, (int)Math.round(v * 20.0)}), 0.05, 60.0, new double[]{1.0, 0.05}).tooltip("gui.rs_ctr.interval");
        gui.compGroup = frame;
        return gui;
    }

    static class StateInteractionHandler
    extends ItemInteractionHandler {
        int phase;
        int interval;

        public StateInteractionHandler(int slot) {
            super((Item)Objects.clock, slot);
        }

        protected void initSync(StateSynchronizer.Builder sb) {
            sb.addMulFix(4, 2);
        }

        public void writeState(StateSyncServer state, AdvancedContainer cont) {
            NBTTagCompound nbt = this.getNBT(cont.player);
            state.writeInt(nbt.func_74762_e("int")).writeInt(nbt.func_74762_e("pha")).endFixed();
        }

        public void readState(StateSyncClient state, AdvancedContainer cont) {
            this.interval = state.get(this.interval);
            this.phase = state.get(this.phase);
        }

        public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
            this.getNBT((EntityPlayer)sender).func_74768_a(pkt.readBoolean() ? "pha" : "int", pkt.readInt());
        }
    }
}

