/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.item;

import cd4017be.lib.item.BaseItemBlock;
import cd4017be.lib.templates.Cover;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.RedstonePort;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRedstonePort
extends BaseItemBlock {
    public ItemRedstonePort(Block id) {
        super(id);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_179222_a(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack stack) {
        return true;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        BlockPos pos1;
        TileEntity te;
        RedstonePort port = null;
        if (hand == EnumHand.OFF_HAND) {
            port = this.replaceBlock(player, world, pos);
        } else if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos) && (te = world.func_175625_s(pos1 = pos.func_177972_a(facing))) instanceof RedstonePort) {
            port = (RedstonePort)te;
            pos = pos1;
            facing = facing.func_176734_d();
        }
        if (port == null) {
            return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == this && player.func_175151_a(pos, facing, stack) && port.addPort(facing, stack.func_77960_j())) {
            stack.func_190918_g(1);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private RedstonePort replaceBlock(EntityPlayer player, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof RedstonePort) {
            return (RedstonePort)te;
        }
        if (!Cover.isBlockValid(null, (IBlockState)state)) {
            return null;
        }
        if (!(player.func_184812_l_() || !(state.func_185903_a(player, world, pos) <= 0.0f) && state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player))) {
            return null;
        }
        ItemStack stack = player.func_184614_ca();
        Block block = state.func_177230_c();
        boolean preCancelEvent = player.func_175149_v() || !player.func_175142_cm() && (stack.func_190926_b() || !stack.func_179544_c(block));
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return null;
        }
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            return null;
        }
        world.func_180498_a(player, 2001, pos, Block.func_176210_f((IBlockState)state));
        if (player.func_184812_l_()) {
            if (!block.removedByPlayer(state, world, pos, player, false)) {
                return null;
            }
            block.func_176206_d(world, pos, state);
        } else {
            ItemStack itemstack2;
            ItemStack itemStack = itemstack2 = stack.func_190926_b() ? ItemStack.field_190927_a : stack.func_77946_l();
            if (!stack.func_190926_b()) {
                stack.func_179548_a(world, state, pos, player);
                if (stack.func_190926_b()) {
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)itemstack2, (EnumHand)EnumHand.MAIN_HAND);
                }
            }
            if (!block.removedByPlayer(state, world, pos, player, true)) {
                return null;
            }
            block.func_176206_d(world, pos, state);
            block.func_180657_a(world, player, pos, state, te, itemstack2);
            int exp = event.getExpToDrop();
            if (exp > 0) {
                block.func_180637_b(world, pos, exp);
            }
        }
        world.func_180501_a(pos, Objects.RS_PORT.func_176223_P(), 11);
        te = world.func_175625_s(pos);
        if (!(te instanceof RedstonePort)) {
            return null;
        }
        RedstonePort port = (RedstonePort)te;
        ItemStack coverStack = ItemStack.field_190927_a;
        for (EntityItem ei : world.func_72872_a(EntityItem.class, new AxisAlignedBB(pos))) {
            if (ei.field_70128_L || (coverStack = ei.func_92059_d()).func_190926_b()) continue;
            world.func_72900_e((Entity)ei);
            break;
        }
        port.cover.stack = coverStack;
        port.cover.state = state;
        port.cover.opaque = state.func_185914_p();
        return port;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            TileEntity te = world.func_175625_s(pos);
            return te instanceof RedstonePort && ((RedstonePort)te).addPort(side.func_176734_d(), stack.func_77960_j());
        }
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this, 1, 0));
        items.add((Object)new ItemStack((Item)this, 1, 1));
        items.add((Object)new ItemStack((Item)this, 1, 2));
        items.add((Object)new ItemStack((Item)this, 1, 3));
    }
}

