/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.render.PortRenderer;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Clock
extends Connector
implements TickRegistry.ITickReceiver,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "clock";
    long phase;
    int interval;
    WorldInfo worldRef;
    SignalHandler callback;

    public Clock(MountedPort port) {
        super(port);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("int", this.interval);
        nbt.func_74768_a("pha", (int)(this.phase % (long)(this.interval << 1)));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.interval = Math.max(1, nbt.func_74762_e("int"));
        this.phase = nbt.func_74762_e("pha");
    }

    protected String id() {
        return ID;
    }

    public boolean tick() {
        if (this.worldRef == null) {
            return false;
        }
        int t = (int)(this.worldRef.func_82573_f() - this.phase);
        if (t == 0) {
            this.callback.updateSignal(65535);
        } else if (t >= this.interval) {
            this.phase += (long)(this.interval << 1);
            this.callback.updateSignal(0);
        }
        return true;
    }

    public void onLoad() {
        if (this.worldRef == null) {
            TickRegistry.instance.add((TickRegistry.ITickReceiver)this);
        }
        this.worldRef = this.port.getWorld().func_72912_H();
        this.callback = (SignalHandler)this.port.owner.getPortCallback(this.port.pin);
        long t = Math.floorMod(this.worldRef.func_82573_f() - this.phase + (long)this.interval, (long)(this.interval << 1)) - (long)this.interval;
        this.phase = this.worldRef.func_82573_f() - t;
        this.callback.updateSignal(t >= 0L ? 65535 : 0);
    }

    public void onUnload() {
        super.onUnload();
        this.worldRef = null;
        this.callback = null;
    }

    public void onRemoved(EntityPlayer player) {
        this.port.owner.onPortModified((Port)this.port, 2);
        ItemStack stack = new ItemStack((Item)Objects.clock);
        stack.func_77982_d(this.serializeNBT());
        this.dropItem(stack, player);
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        PortRenderer.PORT_RENDER.drawModel(quads, (float)this.port.pos.field_72450_a, (float)this.port.pos.field_72448_b, (float)this.port.pos.field_72449_c, Orientation.fromFacing((EnumFacing)this.port.face), "_plug.misc(3)");
    }

    public String displayInfo(MountedPort port, int linkID) {
        return "\n" + TooltipUtil.format((String)"port.rs_ctr.clock", (Object[])new Object[]{Float.valueOf((float)this.interval / 20.0f)});
    }
}

