/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.IIntegratedConnector;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.api.rs_ctr.wire.WiredConnector;
import cd4017be.rs_ctr.port.WireBranch;
import cd4017be.rs_ctr.port.WireType;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LogicPlug
extends Connector
implements IIntegratedConnector,
SignalHandler,
IInteractiveComponent.IBlockRenderComp,
IInteractiveComponent.ITESRenderComp {
    WireBranch wire;
    final Port inPort;
    final Port outPort;
    SignalHandler out = SignalHandler.NOP;

    public LogicPlug(MountedPort port) {
        super(port);
        this.inPort = new Port((IPortProvider)this, 0, SignalHandler.class, false);
        this.outPort = new Port((IPortProvider)this, 1, SignalHandler.class, true);
    }

    public Port getPort(int pin) {
        return pin == 0 ? this.inPort : this.outPort;
    }

    public Object getPortCallback(int pin) {
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        if (callback instanceof SignalHandler) {
            this.out = (SignalHandler)callback;
            this.out.updateSignal(this.getOutput());
        } else {
            this.out = SignalHandler.NOP;
        }
    }

    protected abstract int getOutput();

    public void onPortModified(Port port, int event) {
        this.port.owner.onPortModified((Port)this.port, 16);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74782_a("pi", (NBTBase)this.inPort.serializeNBT());
        nbt.func_74782_a("po", (NBTBase)this.outPort.serializeNBT());
        if (this.wire != null) {
            nbt.func_74782_a("wire", (NBTBase)this.wire.serializeNBT());
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.inPort.deserializeNBT(nbt.func_74775_l("pi"));
        if (nbt.func_150297_b("pos", 4)) {
            this.outPort.deserializeNBT(nbt);
            this.wire = new WireBranch(this.port, WireType.SIGNAL);
            this.wire.deserializeNBT(nbt);
        } else {
            this.outPort.deserializeNBT(nbt.func_74775_l("po"));
            if (nbt.func_150297_b("wire", 10)) {
                this.wire = new WireBranch(this.port, WireType.SIGNAL);
                this.wire.deserializeNBT(nbt.func_74775_l("wire"));
            } else {
                this.wire = null;
            }
        }
    }

    public WiredConnector getLinkedWith(WiredConnector link) {
        return this.wire != null && this.wire.isLinked(link) ? this.wire : null;
    }

    public boolean addWire(WiredConnector con, EntityPlayer player, boolean sim) {
        if (!(con instanceof WireBranch)) {
            return false;
        }
        if (sim) {
            return true;
        }
        if (this.wire != null) {
            this.removeWire(this.wire, player);
        }
        this.wire = (WireBranch)con;
        return true;
    }

    public void removeWire(WiredConnector con, EntityPlayer player) {
        if (con != this.wire) {
            return;
        }
        this.wire = null;
        con.onRemoved(player);
    }

    public Port getPort(WiredConnector con) {
        return con == this.wire ? this.outPort : null;
    }

    public void onRemoved(EntityPlayer player) {
        if (this.wire != null) {
            this.removeWire(this.wire, player);
        }
        this.inPort.disconnect();
    }

    public void onLoad() {
        this.inPort.onLoad();
        this.outPort.onLoad();
        if (this.wire != null) {
            this.wire.onLoad();
        }
        if (this.inPort.getLink() == 0) {
            this.inPort.connect((Port)this.port);
        }
    }

    public void onUnload() {
        this.inPort.onUnload();
        this.outPort.onUnload();
        if (this.wire != null) {
            this.wire.onUnload();
        }
    }

    public void onPortMove() {
        if (this.wire != null) {
            this.wire.onPortMove();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(World world, BlockPos pos, double x, double y, double z, int light, BufferBuilder buffer) {
        if (this.wire != null) {
            this.wire.render(world, pos, x, y, z, light, buffer);
        }
    }

    public AxisAlignedBB getRenderBB(World world, BlockPos pos) {
        return this.wire != null ? this.wire.getRenderBB(world, pos) : null;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        if (this.wire != null) {
            this.wire.render(quads);
        }
    }
}

