/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.port;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.Connector;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.rs_ctr.port.WireConnection;
import cd4017be.rs_ctr.port.WirelessConnection;
import net.minecraft.item.Item;

public enum WireType {
    SIGNAL(SignalHandler.class, "wire", "wireless", "split", -16776961),
    ENERGY(EnergyHandler.class, "wireE", "wirelessE", "splitE", -16711681),
    BLOCK(BlockReference.BlockHandler.class, "wireB", "wirelessB", "splitB", -256);

    public final String wiredId;
    public final String wirelessId;
    public final String splitId;
    public final Class<?> clazz;
    public final int color;
    public Item wireItem;
    public Item wirelessItem;

    private WireType(Class<?> clazz, String wiredId, String wirelessId, String splitId, int color) {
        this.clazz = clazz;
        this.wiredId = wiredId;
        this.wirelessId = wirelessId;
        this.splitId = splitId;
        this.color = color;
    }

    public static void registerAll() {
        for (WireType t : WireType.values()) {
            Connector.REGISTRY.put(t.wiredId, port -> new WireConnection((MountedPort)port, t));
            Connector.REGISTRY.put(t.wirelessId, port -> new WirelessConnection((MountedPort)port, t));
        }
    }

    public String wireModel() {
        return "_plug.wire(" + this.ordinal() + ")";
    }

    public String wirelessModel() {
        return "_plug.wireless(" + this.ordinal() + ")";
    }
}

