/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class BlockMultiplexer
extends WallMountGate
implements SignalHandler,
TickRegistry.IUpdatable {
    final BlockReference[] in = new BlockReference[4];
    BlockReference.BlockHandler out;
    int sel;
    byte tick;
    boolean delayed;

    public BlockMultiplexer() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi0").setLocation(0.25, 0.125, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 1, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi1").setLocation(0.25, 0.375, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 2, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi2").setLocation(0.25, 0.625, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 3, BlockReference.BlockHandler.class, false).setName("port.rs_ctr.bi3").setLocation(0.25, 0.875, 0.125, EnumFacing.WEST), new MountedPort((IPortProvider)this, 4, SignalHandler.class, false).setName("port.rs_ctr.sel").setLocation(0.75, 0.875, 0.125, EnumFacing.EAST), new MountedPort((IPortProvider)this, 5, BlockReference.BlockHandler.class, true).setName("port.rs_ctr.bo").setLocation(0.75, 0.125, 0.125, EnumFacing.EAST)};
    }

    public Object getPortCallback(int pin) {
        if (pin < 4) {
            return ref -> {
                if (BlockReference.equalDelayed((BlockReference)ref, (BlockReference)this.in[pin], (int)1)) {
                    return;
                }
                this.scheduleUpdate();
                this.in[pin] = BlockReference.delayed((BlockReference)ref, (int)1);
            };
        }
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        BlockReference.BlockHandler blockHandler = this.out = callback instanceof BlockReference.BlockHandler ? (BlockReference.BlockHandler)callback : null;
        if (this.out != null) {
            this.out.updateBlock(this.sel >= 0 ? this.in[this.sel] : null);
        }
    }

    @Override
    protected void resetPin(int pin) {
        Object o = this.getPortCallback(pin);
        if (pin < 4) {
            ((BlockReference.BlockHandler)o).updateBlock(null);
        } else {
            this.updateSignal(0);
        }
    }

    public void updateSignal(int value) {
        if (value < 0 || value >= 4) {
            value = -1;
        }
        if (value == this.sel) {
            return;
        }
        this.scheduleUpdate();
        this.sel = value;
    }

    private void scheduleUpdate() {
        if (this.tick == 0) {
            this.tick = TickRegistry.TICK;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
        } else if (this.tick != TickRegistry.TICK) {
            this.tick = TickRegistry.TICK;
            if (this.out != null) {
                this.out.updateBlock(this.sel >= 0 ? this.in[this.sel] : null);
            }
            this.delayed = true;
        }
    }

    public void process() {
        if (this.delayed) {
            this.delayed = false;
            TickRegistry.schedule((TickRegistry.IUpdatable)this);
            return;
        }
        this.tick = 0;
        if (this.out != null) {
            this.out.updateBlock(this.sel >= 0 ? this.in[this.sel] : null);
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74768_a("sel", this.sel);
            for (int i = 0; i < this.in.length; ++i) {
                String key = "in" + i;
                BlockReference ref = this.in[i];
                if (ref != null) {
                    nbt.func_74782_a(key, (NBTBase)ref.serializeNBT());
                    continue;
                }
                nbt.func_82580_o(key);
            }
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.sel = nbt.func_74762_e("sel");
            for (int i = 0; i < this.in.length; ++i) {
                String key = "in" + i;
                this.in[i] = nbt.func_150297_b(key, 10) ? new BlockReference(nbt.func_74775_l(key)) : null;
            }
        }
    }

    @Override
    public Object getState(int id) {
        return id < 4 ? this.in[id] : (id == 4 ? Integer.valueOf(this.sel) : (this.sel < 0 ? null : this.in[this.sel]));
    }
}

