/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.BlockReference;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class BlockSplitter
extends WallMountGate
implements BlockReference.BlockHandler {
    protected final BlockReference.BlockHandler[] callbacks = new BlockReference.BlockHandler[4];
    protected BlockReference state;

    public BlockSplitter() {
        this.ports = new MountedPort[5];
        for (int i = 0; i < 4; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, BlockReference.BlockHandler.class, true).setLocation(0.75, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.EAST).setName("port.rs_ctr.bo");
        }
        this.ports[4] = new MountedPort((IPortProvider)this, 4, BlockReference.BlockHandler.class, false).setLocation(0.25, 0.5, 0.125, EnumFacing.WEST).setName("port.rs_ctr.bi");
    }

    public BlockReference.BlockHandler getPortCallback(int pin) {
        return this;
    }

    public void setPortCallback(int pin, Object callback) {
        BlockReference.BlockHandler c;
        this.callbacks[pin] = c = callback instanceof BlockReference.BlockHandler ? (BlockReference.BlockHandler)callback : null;
        if (c != null) {
            c.updateBlock(this.state);
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateBlock(null);
    }

    public void updateBlock(BlockReference ref) {
        if (BlockReference.equal((BlockReference)this.state, (BlockReference)ref)) {
            return;
        }
        this.state = ref;
        for (BlockReference.BlockHandler c : this.callbacks) {
            if (c == null) continue;
            c.updateBlock(ref);
        }
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            if (this.state != null) {
                nbt.func_74782_a("state", (NBTBase)this.state.serializeNBT());
            } else {
                nbt.func_82580_o("state");
            }
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.state = nbt.func_150297_b("state", 10) ? new BlockReference(nbt.func_74775_l("state")) : null;
        }
        super.loadState(nbt, mode);
    }

    @Override
    public Object getState(int id) {
        return this.state;
    }
}

