/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class Counter
extends WallMountGate
implements SignalHandler {
    SignalHandler outC = SignalHandler.NOP;
    SignalHandler outR = SignalHandler.NOP;
    int clkI;
    int clkO;
    int limit;
    int count;
    boolean dir = true;
    BlockButton button = new BlockButton(a -> {
        this.dir = !this.dir;
        this.markDirty(3);
    }, () -> this.dir ? "_buttons.num(0)" : "_buttons.num(1)", () -> TooltipUtil.translate((String)(this.dir ? "port.rs_ctr.inc" : "port.rs_ctr.dec"))).setSize(0.0625f, 0.0625f);

    public Counter() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, SignalHandler.class, false).setLocation(0.25, 0.875, 0.125, EnumFacing.WEST).setName("port.rs_ctr.clk"), new MountedPort((IPortProvider)this, 1, SignalHandler.class, false).setLocation(0.25, 0.125, 0.125, EnumFacing.WEST).setName("port.rs_ctr.limit"), new MountedPort((IPortProvider)this, 2, SignalHandler.class, true).setLocation(0.75, 0.125, 0.125, EnumFacing.EAST).setName("port.rs_ctr.clko"), new MountedPort((IPortProvider)this, 3, SignalHandler.class, true).setLocation(0.75, 0.875, 0.125, EnumFacing.EAST).setName("port.rs_ctr.count")};
    }

    public SignalHandler getPortCallback(int pin) {
        return pin == 0 ? this : v -> {
            this.limit = v;
        };
    }

    public void setPortCallback(int pin, Object callback) {
        SignalHandler h;
        SignalHandler signalHandler = h = callback instanceof SignalHandler ? (SignalHandler)callback : SignalHandler.NOP;
        if (pin == 2) {
            this.outR = h;
        } else {
            this.outC = h;
        }
    }

    @Override
    protected void resetPin(int pin) {
        if (pin == 1) {
            this.limit = 0;
        }
    }

    public void updateSignal(int value) {
        int c;
        if (value == this.clkI) {
            return;
        }
        this.clkI = value;
        if (this.dir) {
            c = this.count + 1;
            if (c > 0 && c >= this.limit) {
                c = Math.min(0, this.limit + 1);
                this.outR.updateSignal(this.clkO ^= 0xFFFF);
            }
        } else {
            c = this.count - 1;
            if (c < 0 && c <= this.limit) {
                c = Math.max(0, this.limit - 1);
                this.outR.updateSignal(this.clkO ^= 0xFFFF);
            }
        }
        this.count = c;
        this.outC.updateSignal(this.count);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode == 0) {
            nbt.func_74768_a("clkI", this.clkI);
            nbt.func_74768_a("clkO", this.clkO);
            nbt.func_74768_a("lim", this.limit);
            nbt.func_74768_a("cnt", this.count);
        }
        if (mode <= 2) {
            nbt.func_74757_a("dir", this.dir);
        }
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.clkI = nbt.func_74762_e("clkI");
            this.clkO = nbt.func_74762_e("clkO");
            this.limit = nbt.func_74762_e("lim");
            this.count = nbt.func_74762_e("cnt");
        }
        if (mode <= 2) {
            this.dir = nbt.func_74767_n("dir");
        }
        super.loadState(nbt, mode);
    }

    @Override
    protected void orient(Orientation o) {
        this.button.setLocation(0.375, 0.875, 0.25, o);
        super.orient(o);
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this.button);
    }

    @Override
    public Object getState(int id) {
        switch (id) {
            case 0: {
                return this.clkI;
            }
            case 1: {
                return this.limit;
            }
            case 2: {
                return this.clkO;
            }
        }
        return this.count;
    }
}

