/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.GlitchSaveSlot;
import cd4017be.lib.capability.LinkedInventory;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.circuit.CircuitCompiler;
import cd4017be.rs_ctr.circuit.CompiledCircuit;
import cd4017be.rs_ctr.circuit.editor.CircuitInstructionSet;
import cd4017be.rs_ctr.gui.CircuitEditor;
import cd4017be.rs_ctr.item.ItemProcessor;
import cd4017be.rs_ctr.tileentity.Assembler;
import cd4017be.rscpl.editor.Gate;
import cd4017be.rscpl.editor.InvalidSchematicException;
import cd4017be.rscpl.editor.Schematic;
import cd4017be.rscpl.graph.IVariable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class Editor
extends BaseTileEntity
implements IGuiHandlerTile,
AdvancedContainer.IStateInteractionHandler {
    public File lastFile;
    public final Schematic schematic = new Schematic(CircuitInstructionSet.INS_SET, 60, 35);
    public String name = "";
    public int[] ingreds = new int[]{0, 0, 0, 0, 0, 0, 0};
    public ItemStack inventory = ItemStack.field_190927_a;
    public static final int NO_CIRCUITBOARD = 32;
    public static final int MISSING_RESOURCE = 33;
    public static final int MISSING_IO = 34;
    public static final int MISSING_IO_LABEL = 64;
    public static final int UNUSED = 65;
    private static final StateSynchronizer.Builder ssb = StateSynchronizer.builder().addMulFix(4, 7).addVar(1);
    public static final byte A_NEW = -1;
    public static final byte A_LOAD = -2;
    public static final byte A_SAVE = -3;
    public static final byte A_COMPILE = -4;
    public static final byte A_NAME = -5;
    public static final byte A_GO = -6;

    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode >= 1) {
            this.schematic.getChanges(nbt, mode == 1);
        } else {
            nbt.func_74778_a("name", this.name);
            nbt.func_74783_a("ingred", this.ingreds);
            if (!this.inventory.func_190926_b()) {
                nbt.func_74782_a("inv", (NBTBase)this.inventory.func_77955_b(new NBTTagCompound()));
            }
            ByteBuf buf = Unpooled.buffer();
            this.schematic.serialize(buf);
            byte[] data = new byte[buf.writerIndex()];
            buf.readBytes(data);
            nbt.func_74773_a("schematic", data);
        }
    }

    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode >= 1) {
            this.schematic.applyChanges(nbt);
        } else {
            int[] buf;
            this.name = nbt.func_74779_i("name");
            System.arraycopy(buf, 0, this.ingreds, 0, (buf = nbt.func_74759_k("ingred")).length < 7 ? buf.length : 7);
            this.inventory = nbt.func_150297_b("inv", 10) ? new ItemStack(nbt.func_74775_l("inv")) : ItemStack.field_190927_a;
            if (nbt.func_150297_b("schematic", 7)) {
                this.schematic.deserialize(Unpooled.wrappedBuffer((byte[])nbt.func_74770_j("schematic")));
            } else {
                this.schematic.clear();
            }
            this.schematic.resetSync();
            this.computeCost();
        }
    }

    private void computeCost() {
        int a = 0;
        int b = 0;
        HashMap<String, Integer> vars = new HashMap<String, Integer>();
        for (Gate op : this.schematic.operators) {
            if (op == null) continue;
            int i = CircuitInstructionSet.INS_SET.getCost(op.type);
            a += i & 0xFF;
            b += i >> 8 & 0xFF;
            if (!(op instanceof IVariable)) continue;
            vars.merge(((IVariable)((Object)op)).name(), ((IVariable)((Object)op)).memoryUsage(), (o, n) -> n > o ? n : o);
        }
        this.ingreds[3] = a;
        this.ingreds[4] = b;
        a = 0;
        Iterator<Gate> iterator = vars.values().iterator();
        while (iterator.hasNext()) {
            int v = (Integer)((Object)iterator.next());
            a += v;
        }
        this.ingreds[5] = a;
    }

    void compile() throws InvalidSchematicException {
        ItemStack stack = this.inventory;
        if (!(stack.func_77973_b() instanceof ItemProcessor)) {
            throw new InvalidSchematicException(32, null, 0);
        }
        this.computeCost();
        ItemProcessor item = (ItemProcessor)stack.func_77973_b();
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        int[] cmplx = new int[3];
        item.loadStats(stack, cmplx);
        for (int i = 0; i < 3; ++i) {
            if (cmplx[i] >= this.ingreds[i + 3]) continue;
            throw new InvalidSchematicException(33, null, i);
        }
        CompiledCircuit cc = (CompiledCircuit)CircuitCompiler.INSTANCE.compile(this.schematic.operators);
        if (cc.inputs.length > item.maxInPorts(stack)) {
            throw new InvalidSchematicException(34, null, 0);
        }
        if (cc.outputs.length > item.maxOutPorts(stack)) {
            throw new InvalidSchematicException(34, null, 1);
        }
        nbt.func_179237_a(cc.serializeNBT());
        nbt.func_74778_a("name", this.name);
        this.markDirty(0);
        if (cc.compileWarning != null) {
            throw cc.compileWarning;
        }
    }

    void putItem(ItemStack stack, int slot) {
        this.inventory = stack;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.ingreds[6] = 0;
        this.ingreds[2] = 0;
        this.ingreds[1] = 0;
        this.ingreds[0] = 0;
        if (stack.func_77973_b() instanceof ItemProcessor) {
            int[] cmplx = new int[3];
            ((ItemProcessor)stack.func_77973_b()).loadStats(stack, cmplx);
            for (int i = 0; i < 3; ++i) {
                this.ingreds[i] = cmplx[i];
            }
        }
        this.markDirty(0);
    }

    public void onLoad() {
        super.onLoad();
        this.schematic.server = !this.field_145850_b.field_72995_K;
    }

    public AdvancedContainer getContainer(EntityPlayer player, int id) {
        AdvancedContainer cont = new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, ssb.build(this.field_145850_b.field_72995_K), player);
        LinkedInventory inv = new LinkedInventory(1, 64, s -> this.inventory, this::putItem);
        cont.addItemSlot((Slot)new GlitchSaveSlot((IItemHandler)inv, 0, 174, 232, false), false);
        cont.addPlayerInventory(8, 174);
        if (this.field_145850_b.field_72995_K) {
            this.schematic.modified = true;
        }
        return cont;
    }

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        state.writeIntArray(this.ingreds).endFixed().putAll(new Object[]{this.name});
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.ingreds = state.get(this.ingreds);
        this.name = state.get(this.name);
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    @SideOnly(value=Side.CLIENT)
    public CircuitEditor getGuiScreen(EntityPlayer player, int id) {
        return new CircuitEditor(this, player);
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        byte cmd = pkt.readByte();
        this.ingreds[6] = 0;
        switch (cmd) {
            case -1: {
                this.schematic.clear();
                this.name = "";
                break;
            }
            case -2: {
                pkt.readInt();
                this.name = pkt.readCharSequence((int)pkt.readUnsignedByte(), Utils.UTF8).toString();
                this.schematic.deserialize((ByteBuf)pkt);
                sender.func_145747_a((ITextComponent)new TextComponentTranslation("msg.rs_ctr.load_succ", new Object[0]));
                break;
            }
            case -3: {
                return;
            }
            case -4: {
                try {
                    this.compile();
                }
                catch (InvalidSchematicException e) {
                    this.ingreds[6] = e.compact();
                }
                return;
            }
            case -5: {
                this.name = pkt.func_150789_c(64);
                return;
            }
            case -6: {
                Assembler ass = this.getAssembler();
                if (ass == null) {
                    return;
                }
                ItemStack stack = this.inventory;
                if (!stack.func_190926_b()) {
                    this.putItem(ass.buff.items[6], 0);
                    ass.buff.setStackInSlot(6, stack);
                }
                GuiNetworkHandler.openBlockGui((EntityPlayer)sender, (BlockPos)ass.func_174877_v(), (int)0);
                break;
            }
            default: {
                if (!this.schematic.handleUserInput(cmd, (ByteBuf)pkt)) {
                    return;
                }
                if (cmd == 0 || cmd == 1) break;
                this.markDirty(2);
                return;
            }
        }
        this.computeCost();
        this.markDirty(2);
    }

    public Assembler getAssembler() {
        TileEntity te = Utils.neighborTile((TileEntity)this, (EnumFacing)this.getOrientation().rotate(EnumFacing.EAST));
        if (te instanceof Assembler) {
            return (Assembler)te;
        }
        te = Utils.neighborTile((TileEntity)this, (EnumFacing)this.getOrientation().rotate(EnumFacing.WEST));
        if (te instanceof Assembler) {
            return (Assembler)te;
        }
        return null;
    }
}

