/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.DelayedSignal;
import cd4017be.api.rs_ctr.com.EnergyHandler;
import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.api.rs_ctr.port.Port;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.IGuiHandlerTile;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.IServerPacketReceiver;
import cd4017be.lib.network.StateSyncClient;
import cd4017be.lib.network.StateSyncServer;
import cd4017be.lib.network.StateSynchronizer;
import cd4017be.lib.network.SyncNetworkHandler;
import cd4017be.lib.render.Util;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.lib.util.Utils;
import cd4017be.rs_ctr.circuit.Circuit;
import cd4017be.rs_ctr.circuit.CompiledCircuit;
import cd4017be.rs_ctr.circuit.UnloadedCircuit;
import cd4017be.rs_ctr.gui.BlockButton;
import cd4017be.rs_ctr.gui.GuiProcessor;
import cd4017be.rs_ctr.render.ISpecialRenderComp;
import cd4017be.rs_ctr.tileentity.IProcessor;
import cd4017be.rs_ctr.tileentity.Panel;
import cd4017be.rs_ctr.tileentity.Processor;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rscpl.util.StateBuffer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IntegratedPanel
extends WallMountGate
implements TickRegistry.IUpdatable,
IServerPacketReceiver,
IPlayerPacketReceiver,
IProcessor,
Module.IPanel,
ISpecialRenderComp,
AdvancedBlock.ITilePlaceHarvest,
AdvancedContainer.IStateInteractionHandler,
IGuiHandlerTile {
    public static final Pattern LINK_INTERNAL = Pattern.compile("([0-3]{2}).*");
    ItemStack[] ingreds = new ItemStack[0];
    int[] stats = new int[6];
    String name = "";
    BlockButton coreBtn = new BlockButton(null, () -> null, () -> this.name + "\n" + this.getError()){

        @Override
        public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
            if (!hit) {
                GuiNetworkHandler.openBlockGui((EntityPlayer)player, (BlockPos)IntegratedPanel.this.field_174879_c, (int)256);
            }
            return true;
        }
    }.setSize(0.25f, 0.25f);
    public Circuit circuit;
    SignalHandler[] callbacks;
    EnergyHandler energySup;
    private long lastTick = 0L;
    public int energy;
    public int cap;
    public int usage;
    public int gain;
    public byte tick;
    public String lastError;
    DelayedSignal delayed;
    String[] keys = new String[0];
    String[] labels = new String[0];
    Orientation oldO = Orientation.N;
    Module[] modules = new Module[0];
    Set<EntityPlayerMP> watching;
    boolean update;
    int cachedLight;

    public IntegratedPanel() {
        this.ports = new MountedPort[]{new MountedPort((IPortProvider)this, 0, EnergyHandler.class, true)};
        this.watching = null;
        this.cachedLight = -1;
    }

    public void process() {
        this.tick = 0;
        if (this.unloaded) {
            return;
        }
        long t = this.field_145850_b.func_82737_E();
        if (this.lastTick > t) {
            return;
        }
        if (this.usage > 0) {
            int e = this.energy - this.usage + (int)(t - this.lastTick) * this.gain;
            if (e >= 0) {
                this.energy = e <= this.cap ? e : this.cap;
            } else if (this.energySup != null && (e -= this.energySup.changeEnergy(e - this.cap, false)) >= 0) {
                this.energy = e;
            } else {
                this.doBurnout(false);
                this.lastError = "power depleted";
                this.energy = Processor.BURNOUT_INTERVAL * this.gain;
                this.markDirty(2);
                return;
            }
        }
        this.lastTick = t;
        try {
            int d = this.circuit.tick();
            while (this.delayed != null) {
                this.circuit.inputs[this.delayed.id] = this.delayed.value;
                this.delayed = this.delayed.next;
                d |= 1;
            }
            if ((d & 1) != 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            }
            d >>>= 1;
            int i = 0;
            while (d != 0) {
                if ((d & 1) != 0 && this.callbacks[i] != null) {
                    this.callbacks[i].updateSignal(this.circuit.outputs[i]);
                }
                ++i;
                d >>>= 1;
            }
            if (this.lastError != null) {
                this.lastError = null;
                this.markDirty(2);
            }
        }
        catch (Throwable e) {
            this.lastError = this.circuit.processError(e, (TileEntity)this);
            if (this.lastError == null) {
                this.lastError = "BUG! see log";
                this.doBurnout(true);
            } else {
                this.doBurnout(false);
            }
            this.markDirty(2);
        }
    }

    public void doBurnout(boolean hard) {
        Random rand = this.field_145850_b.field_73012_v;
        this.field_145850_b.func_184133_a((EntityPlayer)null, this.field_174879_c, hard ? SoundEvents.field_187539_bB : SoundEvents.field_187745_eA, SoundCategory.BLOCKS, hard ? 5.0f : 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
        for (int i = 0; i < 5; ++i) {
            double d0 = (double)this.field_174879_c.func_177958_n() + rand.nextDouble() * 0.6 + 0.2;
            double d1 = (double)this.field_174879_c.func_177956_o() + rand.nextDouble() * 0.6 + 0.2;
            double d2 = (double)this.field_174879_c.func_177952_p() + rand.nextDouble() * 0.6 + 0.2;
            this.field_145850_b.func_175688_a(hard ? EnumParticleTypes.SMOKE_LARGE : EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
        this.lastTick = hard ? Long.MAX_VALUE : this.field_145850_b.func_82737_E() + (long)Processor.BURNOUT_INTERVAL;
    }

    public SignalHandler getPortCallback(int pin) {
        int[] inputs = this.circuit.inputs;
        return this.circuit.isInterrupt(pin) ? val -> {
            if (inputs[pin] == val) {
                return;
            }
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else if (this.tick != TickRegistry.TICK) {
                this.delayed = new DelayedSignal(pin, val, this.delayed);
                return;
            }
            inputs[pin] = val;
        } : val -> {
            inputs[pin] = val;
        };
    }

    public void setPortCallback(int pin, Object callback) {
        if ((pin -= this.circuit.inputs.length) == this.circuit.outputs.length) {
            this.energySup = callback instanceof EnergyHandler ? (EnergyHandler)callback : null;
        } else {
            SignalHandler scb;
            this.callbacks[pin] = scb = callback instanceof SignalHandler ? (SignalHandler)callback : null;
            if (scb != null) {
                scb.updateSignal(this.circuit.outputs[pin]);
            }
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(0);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        super.storeState(nbt, mode);
        if (mode <= 1 || mode == 4) {
            nbt.func_179237_a(this.circuit.serializeNBT());
            nbt.func_74782_a("labels", (NBTBase)Utils.writeStringArray((String[])this.labels));
            nbt.func_74778_a("name", this.name);
            nbt.func_74783_a("stats", this.stats);
            if (mode != 1) {
                nbt.func_74782_a("ingr", (NBTBase)ItemFluidUtil.saveItems((ItemStack[])this.ingreds));
            }
            if (mode != 4) {
                nbt.func_74768_a("energy", this.energy);
            }
        } else if (mode == 2 && this.lastError != null) {
            nbt.func_74778_a("err", this.lastError);
        }
        if (mode == 0) {
            nbt.func_74772_a("burnout", this.lastTick);
            nbt.func_74757_a("active", this.tick != 0);
        }
        NBTTagList list = new NBTTagList();
        for (Module m : this.modules) {
            list.func_74742_a((NBTBase)(m != null ? m.serializeNBT() : new NBTTagCompound()));
        }
        nbt.func_74782_a("modules", (NBTBase)list);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        int n;
        if (mode <= 1 || mode == 4) {
            this.circuit = mode == 4 ? new CompiledCircuit() : new UnloadedCircuit();
            this.circuit.deserializeNBT(nbt);
            this.labels = Utils.readStringArray((NBTTagList)nbt.func_150295_c("labels", 8), (String[])new String[this.circuit.inputs.length + this.circuit.outputs.length]);
            this.createPorts();
            this.name = nbt.func_74779_i("name");
            this.keys = this.circuit.getState().nbt.func_150296_c().toArray(this.keys);
            Arrays.sort(this.keys);
            int[] arr = nbt.func_74759_k("stats");
            System.arraycopy(arr, 0, this.stats, 0, Math.min(arr.length, this.stats.length));
            if (mode != 1) {
                this.ingreds = ItemFluidUtil.loadItems((NBTTagList)nbt.func_150295_c("ingr", 10));
            }
            this.energy = nbt.func_74762_e("energy");
            this.gain = this.stats[4];
            this.cap = this.stats[5];
            this.usage = this.stats[0] + this.stats[1];
            if (this.usage < this.gain) {
                this.usage = 0;
            }
        } else if (mode == 2) {
            this.lastError = nbt.func_150297_b("err", 8) ? nbt.func_74779_i("err") : null;
        }
        NBTTagList list = nbt.func_150295_c("modules", 10);
        if (mode != 2) {
            for (n = list.func_74745_c(); n > 0 && list.func_150305_b(n - 1).func_82582_d(); --n) {
            }
        }
        if (n != this.modules.length) {
            this.modules = new Module[n];
        }
        ArrayList<MountedPort> ports = new ArrayList<MountedPort>(this.modules.length);
        for (int i = 0; i < this.modules.length; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            String id = tag.func_74779_i("id");
            Module m = this.modules[i];
            if (m == null || !m.id().equals(id)) {
                if (m != null) {
                    m.onUnload();
                }
                this.modules[i] = m = Module.get(id);
            }
            if (m == null) continue;
            m.deserializeNBT((NBTBase)tag);
            m.init(ports, i, this);
            if (this.unloaded) continue;
            m.onLoad(this);
        }
        super.loadState(nbt, mode);
        if (mode == 0) {
            this.lastTick = nbt.func_74763_f("burnout");
            this.tick = (byte)(nbt.func_74767_n("active") ? 1 : 0);
        }
    }

    private void createPorts() {
        String name;
        int i;
        int in = this.circuit.inputs.length;
        int out = this.circuit.outputs.length;
        int ni = 0;
        int no = 0;
        this.ports = new MountedPort[Math.min(out, 4) + Math.min(in, 4) + 1];
        for (i = 0; i < in && ni < 4; ++i) {
            name = this.labels[i];
            if (LINK_INTERNAL.matcher(name).matches()) continue;
            this.ports[ni] = new MountedPort((IPortProvider)this, i, SignalHandler.class, false).setLocation(0.125, 0.125 + (double)ni * 0.25, 0.5, EnumFacing.NORTH, this.o).setName("\\" + name);
            ++ni;
        }
        for (i = 0; i < out && no < 4; ++i) {
            name = this.labels[in + i];
            if (LINK_INTERNAL.matcher(name).matches()) continue;
            this.ports[ni + no] = new MountedPort((IPortProvider)this, in + i, SignalHandler.class, false).setLocation(0.875, 0.125 + (double)no * 0.25, 0.5, EnumFacing.NORTH, this.o).setName("\\" + name);
            ++no;
        }
        this.ports[no += ni] = new MountedPort((IPortProvider)this, in + out, EnergyHandler.class, true).setLocation(0.5, 0.125, 0.5, EnumFacing.NORTH, this.o).setName("port.rs_ctr.energy_i");
        if (++no < this.ports.length) {
            this.ports = Arrays.copyOf(this.ports, no);
        }
    }

    @Override
    public void onLoad() {
        if (this.circuit == null) {
            this.circuit = new UnloadedCircuit();
        }
        if (!this.field_145850_b.field_72995_K) {
            this.circuit = this.circuit.load();
            this.callbacks = new SignalHandler[this.circuit.outputs.length];
            if (this.tick == 1) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            }
        }
        for (Module m : this.modules) {
            if (m == null) continue;
            m.onLoad(this);
        }
        super.onLoad();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        int in = this.circuit.inputs.length;
        block1: for (int i = 0; i < this.labels.length; ++i) {
            Matcher m = LINK_INTERNAL.matcher(this.labels[i]);
            if (!m.matches()) continue;
            int p = 1 << Integer.parseInt(m.group(1), 4);
            for (Module mod : this.modules) {
                if (mod == null || (mod.getBounds() & p) == 0) continue;
                if (i < in) {
                    mod.setPortCallback(this.getPortCallback(i));
                    continue block1;
                }
                this.setPortCallback(i, mod.getPortCallback());
                continue block1;
            }
        }
    }

    @Override
    protected void onUnload() {
        super.onUnload();
        if (!this.field_145850_b.field_72995_K) {
            for (int i = this.circuit.inputs.length; i < this.labels.length; ++i) {
                this.setPortCallback(i, null);
            }
        }
        for (Module m : this.modules) {
            if (m == null) continue;
            if (!this.field_145850_b.field_72995_K) {
                m.setPortCallback(null);
            }
            m.onUnload();
        }
        this.watching = null;
    }

    @Override
    protected void initGuiComps(List<IInteractiveComponent> list) {
        list.add(this.coreBtn);
        for (Module m : this.modules) {
            if (m == null) continue;
            list.add(m);
        }
    }

    @Override
    protected void orient(Orientation o) {
        this.coreBtn.setLocation(0.5, 0.375, 0.75, Orientation.values()[o.ordinal() ^ 8]);
        super.orient(o);
    }

    public void onPlaced(EntityLivingBase entity, ItemStack item) {
        NBTTagCompound nbt = item.func_77978_p();
        if (nbt == null) {
            return;
        }
        this.loadState(nbt, 4);
        this.energy = this.cap;
        this.lastTick = this.field_145850_b.func_82737_E();
        this.tick = 1;
        this.unloaded = true;
        this.onLoad();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.markDirty(3);
        if (entity instanceof EntityPlayerMP) {
            this.handlePlayerPacket(null, (EntityPlayerMP)entity);
        }
    }

    public List<ItemStack> dropItem(IBlockState state, int fortune) {
        return this.makeDefaultDrops();
    }

    @Override
    public String getName() {
        return "\\" + this.name;
    }

    @Override
    public String getError() {
        return this.lastError == null ? "\u00a7ano error" : "\u00a7c" + this.lastError;
    }

    @Override
    public String[] getIOLabels() {
        return this.labels;
    }

    @Override
    public double getExhaustion() {
        return (double)(this.cap - this.energy) / (double)this.cap * 100.0;
    }

    @Override
    public Circuit getCircuit() {
        return this.circuit;
    }

    @Override
    public int getClockState() {
        return this.tick;
    }

    public Container getContainer(EntityPlayer player, int id) {
        if (id < this.modules.length) {
            return this.modules[id].getCfgContainer(player);
        }
        return new AdvancedContainer((AdvancedContainer.IStateInteractionHandler)this, StateSynchronizer.builder().addFix(new int[]{1, 4}).addMulFix(4, this.circuit.inputs.length + this.circuit.outputs.length).addVar(this.keys.length).build(this.field_145850_b.field_72995_K), player);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGuiScreen(EntityPlayer player, int id) {
        if (id < this.modules.length) {
            return this.modules[id].getCfgScreen(player);
        }
        return new GuiProcessor(this, (AdvancedContainer)this.getContainer(player, id));
    }

    public void writeState(StateSyncServer state, AdvancedContainer cont) {
        state.writeInt(this.tick > 0 ? 1 : 0).writeInt(Math.min(this.cap, this.energy + (int)(this.field_145850_b.func_82737_E() - this.lastTick - 1L) * this.gain));
        state.writeIntArray(this.circuit.inputs).writeIntArray(this.circuit.outputs).endFixed();
        NBTTagCompound nbt = this.circuit.getState().nbt;
        for (String key : this.keys) {
            Utils.writeTag((ByteBuf)state.buffer, (NBTBase)nbt.func_74781_a(key));
            state.put();
        }
    }

    public void readState(StateSyncClient state, AdvancedContainer cont) {
        this.tick = (byte)state.get((int)this.tick);
        this.energy = state.get(this.energy);
        this.circuit.inputs = state.get(this.circuit.inputs);
        this.circuit.outputs = state.get(this.circuit.outputs);
        NBTTagCompound nbt = this.circuit.getState().nbt;
        for (String key : this.keys) {
            if (!state.next()) continue;
            nbt.func_74782_a(key, Utils.readTag((ByteBuf)state.buffer, (byte)nbt.func_150299_b(key)));
        }
    }

    public boolean canInteract(EntityPlayer player, AdvancedContainer cont) {
        return this.canPlayerAccessUI(player);
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        String key;
        short var = pkt.readUnsignedByte();
        if (var == 255) {
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            }
            return;
        }
        if (var >= this.keys.length || (key = this.keys[var]) == null) {
            return;
        }
        StateBuffer state = this.circuit.getState();
        state.nbt.func_74782_a(key, Utils.readTag((ByteBuf)pkt, (byte)state.nbt.func_150299_b(key)));
        this.circuit.setState(state);
    }

    @Override
    public Object getState(int id) {
        return id < this.circuit.inputs.length ? this.circuit.inputs[id] : ((id -= this.circuit.inputs.length) < this.circuit.outputs.length ? Integer.valueOf(this.circuit.outputs[id]) : null);
    }

    @Override
    public Port getPort(int pin) {
        Port p = super.getPort(pin);
        if (p == null) {
            for (MountedPort port : this.ports) {
                if (port.pin != pin) continue;
                return port;
            }
        }
        return p;
    }

    @Override
    public void remove(int id) {
        Module m = this.modules[id];
        if (m != null) {
            int b = m.getBounds();
            m.setPortCallback(null);
            int in = this.circuit.inputs.length;
            for (int i = 0; i < this.labels.length; ++i) {
                int p;
                Matcher mt = LINK_INTERNAL.matcher(this.labels[i]);
                if (!mt.matches() || (b & (p = 1 << Integer.parseInt(mt.group(1), 4))) == 0) continue;
                if (i < in) {
                    this.resetPin(i);
                    continue;
                }
                this.setPortCallback(i, null);
            }
            m.onUnload();
            this.modules[id] = null;
        }
        this.gui = null;
        this.markDirty(3);
    }

    @Override
    public boolean add(Module m) {
        int b = m.getBounds();
        int i = -1;
        for (int j = 0; j < this.modules.length; ++j) {
            Module mod = this.modules[j];
            if (mod != null) {
                if ((mod.getBounds() & b) == 0) continue;
                return false;
            }
            if (i >= 0) continue;
            i = j;
        }
        if (i < 0) {
            i = this.modules.length;
            this.modules = Arrays.copyOf(this.modules, i + 1);
        }
        ArrayList<MountedPort> list = new ArrayList<MountedPort>();
        m.init(list, i, this);
        for (MountedPort port : list) {
            if (port.face != this.o.back) continue;
            return false;
        }
        this.modules[i] = m;
        m.onLoad(this);
        if (!list.isEmpty()) {
            int in = this.circuit.inputs.length;
            for (i = 0; i < this.labels.length; ++i) {
                int p;
                Matcher mt = LINK_INTERNAL.matcher(this.labels[i]);
                if (!mt.matches() || ((p = 1 << Integer.parseInt(mt.group(1), 4)) & b) == 0) continue;
                if (i < in) {
                    m.setPortCallback(this.getPortCallback(i));
                    continue;
                }
                this.setPortCallback(i, m.getPortCallback());
            }
        }
        this.markDirty(3);
        this.gui = null;
        return true;
    }

    @Override
    public void updateDisplay() {
        if (this.watching != null && !this.update) {
            this.update = true;
            TickRegistry.schedule(this::syncPanelState);
        }
        this.markDirty(0);
    }

    public void syncPanelState() {
        this.update = false;
        if (this.watching == null) {
            return;
        }
        Iterator<EntityPlayerMP> it = this.watching.iterator();
        while (it.hasNext()) {
            EntityPlayerMP player = it.next();
            if (!player.field_70128_L && !(player.func_174831_c(this.field_174879_c) > Panel.UPDATE_RANGE1)) continue;
            it.remove();
        }
        if (this.watching.isEmpty()) {
            this.watching = null;
        } else {
            PacketBuffer pkt = SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c);
            for (Module m : this.modules) {
                if (m == null) continue;
                m.writeSync(pkt, false);
            }
            SyncNetworkHandler.instance.sendToPlayers(pkt, this.watching);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleServerPacket(PacketBuffer pkt) throws Exception {
        for (Module m : this.modules) {
            if (m == null) continue;
            m.readSync(pkt);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean hasFastRenderer() {
        double d = Minecraft.func_71410_x().field_71439_g.func_174831_c(this.field_174879_c);
        if (d > Panel.UPDATE_RANGE0) {
            this.watching = null;
        } else if (this.watching == null) {
            this.watching = Collections.emptySet();
            SyncNetworkHandler.instance.sendToServer(SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c));
        }
        return d > Panel.TEXT_RANGE;
    }

    public void handlePlayerPacket(PacketBuffer pkt, EntityPlayerMP sender) {
        if (sender.field_70128_L || sender.func_174831_c(this.field_174879_c) > Panel.UPDATE_RANGE1) {
            return;
        }
        if (this.watching == null) {
            this.watching = new HashSet<EntityPlayerMP>(2);
        }
        if (this.watching.add(sender)) {
            pkt = SyncNetworkHandler.preparePacket((BlockPos)this.field_174879_c);
            for (Module m : this.modules) {
                if (m == null) continue;
                m.writeSync(pkt, true);
            }
            SyncNetworkHandler.instance.sendToPlayer(pkt, sender);
        }
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }

    @Override
    public void renderSpecial(double x, double y, double z, float t, FontRenderer fr) {
        GlStateManager.func_179094_E();
        Util.moveAndOrientToBlock((double)x, (double)y, (double)z, (Orientation)this.o);
        GlStateManager.func_179137_b((double)-0.5, (double)0.5, (double)0.505);
        GlStateManager.func_179139_a((double)0.0078125, (double)-0.0078125, (double)-1.0);
        Util.luminate((TileEntity)this, (EnumFacing)this.o.back, (int)0);
        for (Module m : this.modules) {
            if (m == null) continue;
            m.drawText(fr);
        }
        GlStateManager.func_179121_F();
        this.cachedLight = -1;
    }

    @Override
    public int frontLight() {
        int l = this.cachedLight;
        if (l >= 0) {
            return l;
        }
        this.cachedLight = this.field_145850_b.func_175626_b(this.field_174879_c.func_177972_a(this.o.back), 0);
        return this.cachedLight;
    }
}

