/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.IStateInfo;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.TickRegistry;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class SignalDelayer
extends WallMountGate
implements IStateInfo {
    private final Delay[] channels = new Delay[4];

    public SignalDelayer() {
        this.ports = new MountedPort[8];
        for (int i = 0; i < 4; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, SignalHandler.class, false).setLocation(0.25, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.WEST).setName("port.rs_ctr.i");
            this.ports[i + 4] = new MountedPort((IPortProvider)this, i + 4, SignalHandler.class, true).setLocation(0.75, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.EAST).setName("port.rs_ctr.o");
            this.channels[i] = new Delay();
        }
    }

    public SignalHandler getPortCallback(int pin) {
        return this.channels[pin];
    }

    public void setPortCallback(int pin, Object callback) {
        Delay c = this.channels[pin - 4];
        if (callback instanceof SignalHandler) {
            c.out = (SignalHandler)callback;
            c.out.updateSignal(c.state);
        } else {
            c.out = SignalHandler.NOP;
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.channels[pin].updateSignal(0);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            int[] states = new int[4];
            for (int i = 0; i < 4; ++i) {
                states[i] = this.channels[i].state;
            }
            nbt.func_74783_a("states", states);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        super.loadState(nbt, mode);
        if (mode == 0) {
            int[] states = nbt.func_74759_k("states");
            for (int i = 0; i < 4 && i < states.length; ++i) {
                this.channels[i].state = states[i];
            }
        }
    }

    @Override
    public Object getState(int id) {
        return this.channels[id & 3].state;
    }

    static class Delay
    implements SignalHandler,
    TickRegistry.IUpdatable {
        SignalHandler out = SignalHandler.NOP;
        int state;
        byte tick;

        Delay() {
        }

        public void updateSignal(int value) {
            if (value == this.state) {
                return;
            }
            if (this.tick == 0) {
                this.tick = TickRegistry.TICK;
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else if (this.tick != TickRegistry.TICK) {
                this.tick = TickRegistry.TICK;
                this.out.updateSignal(this.state);
            }
            this.state = value;
        }

        public void process() {
            if (this.tick == TickRegistry.TICK) {
                TickRegistry.schedule((TickRegistry.IUpdatable)this);
            } else {
                this.tick = 0;
                this.out.updateSignal(this.state);
            }
        }
    }
}

