/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.IStateInfo;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.rs_ctr.tileentity.WallMountGate;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class SignalSplitter
extends WallMountGate
implements IStateInfo {
    protected final SignalHandler[] callbacks = new SignalHandler[4];
    protected int state;

    public SignalSplitter() {
        this.ports = new MountedPort[5];
        for (int i = 0; i < 4; ++i) {
            this.ports[i] = new MountedPort((IPortProvider)this, i, SignalHandler.class, true).setLocation(0.75, (double)(0.125f + (float)i * 0.25f), 0.125, EnumFacing.EAST).setName("port.rs_ctr.o");
        }
        this.ports[4] = new MountedPort((IPortProvider)this, 4, SignalHandler.class, false).setLocation(0.25, 0.5, 0.125, EnumFacing.WEST).setName("port.rs_ctr.i");
    }

    public SignalHandler getPortCallback(int pin) {
        return val -> {
            if (val == this.state) {
                return;
            }
            this.state = val;
            for (SignalHandler c : this.callbacks) {
                if (c == null) continue;
                c.updateSignal(val);
            }
        };
    }

    public void setPortCallback(int pin, Object callback) {
        SignalHandler c;
        this.callbacks[pin] = c = callback instanceof SignalHandler ? (SignalHandler)callback : null;
        if (c != null) {
            c.updateSignal(this.state);
        }
    }

    @Override
    protected void resetPin(int pin) {
        this.getPortCallback(pin).updateSignal(0);
    }

    @Override
    protected void storeState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            nbt.func_74768_a("state", this.state);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected void loadState(NBTTagCompound nbt, int mode) {
        if (mode == 0) {
            this.state = nbt.func_74762_e("state");
        }
        super.loadState(nbt, mode);
    }

    @Override
    public Object getState(int id) {
        return this.state;
    }
}

