/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.render.model.IntArrayModel;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.render.PortRenderer;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import cd4017be.rs_ctr.tileentity.part._7Segment;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Lamp
extends SignalModule
implements SignalHandler {
    public static final String ID = "lamp";
    byte color;
    int thr;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        this.pos = (byte)((int)Math.floor(x * 4.0f) & 3 | (int)Math.floor(y * 4.0f) << 2 & 0xC);
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.lamp);
    }

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, false).setLocation(this.getX() + 0.125, this.getY() + 0.125, 0.75, EnumFacing.NORTH, panel.getOrientation()).setName("port.rs_ctr.i"));
        super.init(ports, idx, panel);
    }

    public void updateSignal(int value) {
        if (value > this.thr ^ this.value > this.thr) {
            this.host.updateDisplay();
        }
        this.value = value;
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("color", this.color);
        nbt.func_74768_a("thr", this.thr);
        return nbt;
    }

    @Override
    public void loadCfg(NBTTagCompound nbt) {
        this.color = nbt.func_74771_c("color");
        this.thr = nbt.func_74762_e("thr");
        super.loadCfg(nbt);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        Vec3d p = o.X.func_186678_a(this.getX()).func_178787_e(o.Y.func_186678_a(this.getY())).func_178787_e(o.Z.func_186678_a(-0.046875));
        int c = this.color & 0xF;
        if (this.value <= this.thr) {
            c |= 0x10;
        }
        IntArrayModel m = PortRenderer.PORT_RENDER.getModel("_lever.btn").rotated(o);
        m.origin(-((float)p.field_72450_a), -((float)p.field_72448_b), -((float)p.field_72449_c)).setColor(_7Segment.COLORS[c]);
        m.setBrightness(this.brightness(light));
        this.renderCache = m;
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected int brightness(int light) {
        return this.value > this.thr ? light & 0xFF0000 | 0xF0 : light;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawText(FontRenderer fr) {
        if (this.title.isEmpty()) {
            return;
        }
        float dz = 0.015625f;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)(-dz));
        int x = (this.pos & 3) * 32;
        int y = 96 - (this.pos >> 2 & 3) * 32;
        List lines = fr.func_78271_c(this.title, 26);
        y += (32 - lines.size() * 8) / 2;
        for (String s : lines) {
            fr.func_78276_b(s, x + (32 - fr.func_78256_a(s)) / 2, y, -16777216);
            y += 8;
        }
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)dz);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 80, 53, 3).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 0, 151);
        new TextField((GuiCompGroup)frame, 64, 7, 8, 16, 16, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)0, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new TextField((GuiCompGroup)frame, 64, 7, 8, 29, 12, () -> Integer.toString(this.thr), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)1, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.thr");
        new Button((GuiCompGroup)frame, 9, 9, 7, 37, 16, () -> this.color & 0xF, s -> gui.sendPkt(new Object[]{(byte)2, (byte)s})).texture(247, 72).tooltip("gui.rs_ctr.color");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            case 1: {
                this.thr = pkt.readInt();
                break;
            }
            case 2: {
                this.color = pkt.readByte();
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(2);
    }
}

