/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.AdvancedContainer;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.render.Util;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.ClientProxy;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.tileentity.part.Module;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Oscilloscope
extends Module
implements SignalHandler,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "oscilloscope";
    protected byte pos;
    SignalHandler out;
    int[] graph = new int[0];
    int value;
    int idx;
    int lastSend;
    boolean paused;
    private static final ByteBuffer vertexArray;

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        Orientation o = panel.getOrientation();
        double x = this.getX() + 0.125;
        double y = this.getY() + 0.375;
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, false).setLocation(x + this.getW(), y, 0.75, EnumFacing.NORTH, o).setName("port.rs_ctr.i"));
        ports.add(new MountedPort((IPortProvider)panel, idx << 1 | 1, SignalHandler.class, true).setLocation(x, y, 0.75, EnumFacing.NORTH, o).setName("port.rs_ctr.o"));
        super.init(ports, idx, panel);
    }

    public void updateSignal(int value) {
        if (this.paused || ((value ^ this.value) & 0xFF000000) == 0) {
            return;
        }
        if (this.out != null) {
            this.out.updateSignal(this.graph[this.idx]);
        }
        if ((value & 0xFF) > 100) {
            value = value & 0xFFFFFF00 | 0x64;
        }
        if ((value >> 8 & 0xFF) > 100) {
            value = value & 0xFFFF00FF | 0x6400;
        }
        if ((value >> 16 & 0xFF) > 100) {
            value = value & 0xFF00FFFF | 0x640000;
        }
        this.graph[this.idx] = this.value = value;
        if (++this.idx >= this.graph.length) {
            this.idx = 0;
        }
        this.host.updateDisplay();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74774_a("pos", this.pos);
        nbt.func_74768_a("val", this.value);
        nbt.func_74774_a("idx", (byte)this.idx);
        nbt.func_74783_a("graph", this.graph);
        nbt.func_74757_a("pause", this.paused);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int l;
        this.pos = (byte)(nbt.func_150297_b("pos", 1) ? (int)nbt.func_74771_c("pos") : -16);
        int n = l = (this.pos & 0x20) != 0 ? 100 : 50;
        if (this.graph.length != l) {
            this.graph = new int[l];
        }
        this.value = nbt.func_74762_e("val");
        this.lastSend = this.idx = (nbt.func_74771_c("idx") & 0xFF) % l;
        int[] arr = nbt.func_74759_k("graph");
        System.arraycopy(arr, 0, this.graph, 0, Math.min(arr.length, l));
        this.paused = nbt.func_74767_n("pause");
        this.loadCfg(nbt);
    }

    @Override
    protected void loadCfg(NBTTagCompound nbt) {
    }

    @Override
    public int getBounds() {
        return (15 >> 3 - (this.pos >> 4 & 3)) * (4369 >> 12 - (this.pos >> 4 & 0xC)) << (this.pos & 0xF);
    }

    protected double getX() {
        return (double)(this.pos & 3) * 0.25;
    }

    protected double getY() {
        return (double)(this.pos >> 2 & 3) * 0.25;
    }

    protected double getW() {
        return (double)(this.pos >> 4 & 3) * 0.25;
    }

    protected double getH() {
        return (double)(this.pos >> 6 & 3) * 0.25;
    }

    @Override
    public Object getPortCallback() {
        return this;
    }

    @Override
    public void setPortCallback(Object callback) {
        SignalHandler signalHandler = this.out = callback instanceof SignalHandler ? (SignalHandler)callback : null;
        if (this.out != null) {
            int l = this.graph.length;
            this.out.updateSignal(this.graph[(this.idx - 1 + l) % l]);
        }
    }

    @Override
    public void resetInput() {
    }

    @Override
    public void writeSync(PacketBuffer buf, boolean init) {
        int l = this.graph.length;
        if (init) {
            buf.writeByte(-1 - this.idx);
            for (int i = 0; i < l; ++i) {
                buf.writeInt(this.graph[i]);
            }
        } else {
            buf.writeByte(this.lastSend);
            buf.writeByte(this.idx);
            while (this.lastSend != this.idx) {
                buf.writeInt(this.graph[this.lastSend]);
                if (++this.lastSend < l) continue;
                this.lastSend -= l;
            }
        }
        buf.writeBoolean(this.paused);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readSync(PacketBuffer buf) {
        int idx = buf.readByte();
        int l = this.graph.length;
        if (idx < 0) {
            this.idx = (-1 - idx) % l;
            for (int i = 0; i < l; ++i) {
                this.graph[i] = buf.readInt();
            }
        } else {
            int m = idx % l;
            this.idx = idx = (buf.readByte() & 0xFF) % l;
            while (m != idx) {
                this.graph[m] = buf.readInt();
                if (++m < l) continue;
                m -= l;
            }
        }
        this.paused = buf.readBoolean();
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        Orientation o = host.getOrientation();
        Vec3d p = o.rotate(new Vec3d(this.getX(), this.getY(), 0.505)).func_72441_c(0.5, 0.5, 0.5);
        Vec2f t0 = Util.getUV((TextureAtlasSprite)ClientProxy.t_osc, (float)0.125f, (float)0.125f);
        Vec2f t1 = Util.getUV((TextureAtlasSprite)ClientProxy.t_osc, (float)12.625f, (float)12.625f);
        quads.add(new BakedQuad(Util.texturedRect((Vec3d)p, (Vec3d)o.X.func_186678_a(-0.5), (Vec3d)o.Y.func_186678_a(-0.5), (Vec2f)t0, (Vec2f)t1, (int)-12632257, (int)0), -1, o.back, ClientProxy.t_osc, true, DefaultVertexFormats.field_176600_a));
        if ((this.pos & 0x20) != 0) {
            quads.add(new BakedQuad(Util.texturedRect((Vec3d)p.func_178787_e(o.X.func_186678_a(0.5)), (Vec3d)o.X.func_186678_a(-0.5), (Vec3d)o.Y.func_186678_a(-0.5), (Vec2f)t0, (Vec2f)t1, (int)-12632257, (int)0), -1, o.back, ClientProxy.t_osc, true, DefaultVertexFormats.field_176600_a));
        }
        if ((this.pos & 0x80) != 0) {
            quads.add(new BakedQuad(Util.texturedRect((Vec3d)p.func_178787_e(o.X.func_186678_a(-0.5)), (Vec3d)o.X.func_186678_a(0.5), (Vec3d)o.Y.func_186678_a(0.5), (Vec2f)t0, (Vec2f)t1, (int)-12632257, (int)0), -1, o.back, ClientProxy.t_osc, true, DefaultVertexFormats.field_176600_a));
        }
        if ((this.pos & 0xA0) == 160) {
            quads.add(new BakedQuad(Util.texturedRect((Vec3d)p, (Vec3d)o.X.func_186678_a(0.5), (Vec3d)o.Y.func_186678_a(0.5), (Vec2f)t0, (Vec2f)t1, (int)-12632257, (int)0), -1, o.back, ClientProxy.t_osc, true, DefaultVertexFormats.field_176600_a));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawText(FontRenderer fr) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(0.64 + (double)((this.pos & 3) * 32)), (double)(128 - (this.pos >> 2 & 3) * 32), (double)-0.01);
        fr.func_78276_b(this.paused ? "\u2223\u2223" : "\u25b6", 0, (this.pos & 0x80) != 0 ? -128 : -64, -1);
        GlStateManager.func_179139_a((double)1.28, (double)((this.pos & 0x80) != 0 ? -1.28 : -0.64), (double)1.0);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179140_f();
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_187410_q((int)32884);
        GlStateManager.func_187427_b((int)2, (int)5120, (int)2, (ByteBuffer)vertexArray);
        int l = this.graph.length;
        for (int i = 0; i < 24; i += 8) {
            int idx;
            GlStateManager.func_179131_c((float)(i == 0 ? 1.0f : 0.0f), (float)(i == 8 ? 1.0f : 0.0f), (float)(i == 16 ? 1.0f : 0.0f), (float)1.0f);
            int k = 1;
            int j = idx = this.idx + 1;
            while (j < l) {
                vertexArray.put(k, (byte)(this.graph[j] >> i));
                ++j;
                k += 2;
            }
            j = 0;
            while (j < idx) {
                vertexArray.put(k, (byte)(this.graph[j] >> i));
                ++j;
                k += 2;
            }
            GlStateManager.func_187439_f((int)3, (int)0, (int)l);
        }
        GlStateManager.func_187429_p((int)32884);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }

    @Override
    public boolean onInteract(EntityPlayer player, boolean hit, EnumFacing side, Vec3d aim) {
        if (super.onInteract(player, hit, side, aim)) {
            return true;
        }
        if (hit) {
            return false;
        }
        this.paused = !this.paused;
        this.host.updateDisplay();
        return true;
    }

    public AdvancedContainer getCfgContainer(EntityPlayer player) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ModularGui getCfgScreen(EntityPlayer player) {
        return null;
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        int m = stack.func_77960_j();
        this.pos = (byte)(0x50 | ((m & 1) == 0 ? (int)Math.floor(x * 3.0f) & 3 : 32) | ((m & 2) == 0 ? (int)Math.floor(y * 3.0f) << 2 & 0xC : 128));
        this.graph = new int[(m & 1) != 0 ? 100 : 50];
    }

    @Override
    public String id() {
        return ID;
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.oscilloscope);
    }

    @Override
    public Object getState(int id) {
        return id == 0 ? this.value : this.graph[this.idx];
    }

    static {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            vertexArray = GLAllocation.func_74524_c((int)200);
            for (int i = 0; i < 100; ++i) {
                vertexArray.put((byte)i).put((byte)0);
            }
            vertexArray.flip();
        } else {
            vertexArray = null;
        }
    }
}

