/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr.tileentity.part;

import cd4017be.api.rs_ctr.com.SignalHandler;
import cd4017be.api.rs_ctr.interact.IInteractiveComponent;
import cd4017be.api.rs_ctr.port.IPortProvider;
import cd4017be.api.rs_ctr.port.MountedPort;
import cd4017be.lib.Gui.ModularGui;
import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.TextField;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr.Objects;
import cd4017be.rs_ctr.render.PanelRenderer;
import cd4017be.rs_ctr.tileentity.part.Module;
import cd4017be.rs_ctr.tileentity.part.SignalModule;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PointerDisplay
extends SignalModule
implements SignalHandler,
IInteractiveComponent.IBlockRenderComp {
    public static final String ID = "pointer";
    int max = 15;
    int min = 0;
    int exp = 0;
    String unit = "";
    static final char[] PREFIX = new char[]{'p', 'n', '\u03bc', 'm', ' ', 'k', 'M', 'G', 'T', 'P', 'E'};
    static final byte A_MIN = 0;
    static final byte A_MAX = 1;
    static final byte A_EXP = 2;
    static final byte A_UNIT = 4;
    static final byte A_TITLE = 5;

    @Override
    public String id() {
        return ID;
    }

    @Override
    public void onPlaced(ItemStack stack, float x, float y) {
        int m = stack.func_77960_j();
        this.pos = (byte)(0x50 | ((m & 1) == 0 ? (int)Math.floor(x * 3.0f) & 3 : 32) | ((m & 2) == 0 ? (int)Math.floor(y * 3.0f) << 2 & 0xC : 128));
    }

    @Override
    public ItemStack onRemove() {
        return new ItemStack((Item)Objects.pointer_dsp);
    }

    @Override
    public void init(List<MountedPort> ports, int idx, Module.IPanel panel) {
        Orientation o = panel.getOrientation();
        ports.add(new MountedPort((IPortProvider)panel, idx << 1, SignalHandler.class, false).setLocation(this.getX() + this.getW() * 0.5, this.getY() + this.getH() * 0.5, 0.75, EnumFacing.NORTH, o).setName("port.rs_ctr.i"));
        super.init(ports, idx, panel);
    }

    public void updateSignal(int value) {
        if (this.value == value) {
            return;
        }
        this.value = value;
        this.host.updateDisplay();
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = super.serializeNBT();
        nbt.func_74768_a("max", this.max);
        nbt.func_74768_a("min", this.min);
        nbt.func_74774_a("exp", (byte)this.exp);
        nbt.func_74778_a("unit", this.unit);
        return nbt;
    }

    @Override
    public void loadCfg(NBTTagCompound nbt) {
        this.max = nbt.func_74762_e("max");
        this.min = nbt.func_74762_e("min");
        this.exp = nbt.func_74771_c("exp");
        this.unit = nbt.func_74779_i("unit");
        super.loadCfg(nbt);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean refreshFTESR(Orientation o, double x, double y, double z, int light, BufferBuilder buffer) {
        this.renderCache = PanelRenderer.Layout.of(this.pos >> 5 & 1 | this.pos >> 6 & 2).getPointer(((double)this.value - (double)this.min) / ((double)this.max - (double)this.min), light, (float)this.getX(), (float)this.getY()).rotated(o);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(List<BakedQuad> quads) {
        int i;
        Module.IPanel host = this.host;
        if (host == null) {
            return;
        }
        int color = -16777216;
        if (this.unit.length() >= 2 && this.unit.charAt(0) == '\u00a7' && (i = Minecraft.func_71410_x().field_71466_p.func_175064_b(Character.toLowerCase(this.unit.charAt(1)))) != -1) {
            color |= i & 0xFF00 | i >> 16 & 0xFF | i << 16 & 0xFF0000;
        }
        PanelRenderer.Layout.of(this.pos >> 5 & 1 | this.pos >> 6 & 2).drawScale(quads, host.getOrientation(), this.min, this.max, this.exp, color, (float)this.getX(), (float)this.getY());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawText(FontRenderer fr) {
        int x = (this.pos & 3) * 32;
        int y = 64 - (this.pos & 0xC) * 8;
        int exp = this.exp;
        for (int mag = Math.max(Math.abs(this.min), Math.abs(this.max)); mag >= 10; mag /= 10) {
            ++exp;
        }
        exp = (exp + 12) / 3;
        String unit = this.unit;
        if (exp != 4 && exp >= 0 && exp < PREFIX.length) {
            unit = FontRenderer.func_78282_e((String)unit) + PREFIX[exp] + unit;
        }
        switch (this.pos >> 5 & 5) {
            case 0: {
                fr.func_78279_b(this.title, x + 1, y + 1, 50, -16777216);
                fr.func_78276_b(unit, x + (84 - fr.func_78256_a(unit)) / 2, y + 44, -16777216);
                break;
            }
            case 1: {
                fr.func_78276_b(this.title, (128 - fr.func_78256_a(this.title)) / 2, y, -16777216);
                fr.func_78276_b(unit, (128 - fr.func_78256_a(unit)) / 2, y + 42, -16777216);
                break;
            }
            case 4: {
                fr.func_78279_b(this.title, x + 8, 8, 50, -16777216);
                fr.func_78276_b(unit, x + (84 - fr.func_78256_a(unit)) / 2, 62, -16777216);
                break;
            }
            default: {
                fr.func_78276_b(this.title, (128 - fr.func_78256_a(this.title)) / 2, 10, -16777216);
                fr.func_78276_b(unit, (128 - fr.func_78256_a(unit)) / 2, 88, -16777216);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiFrame initGuiFrame(ModularGui gui) {
        GuiFrame frame = new GuiFrame(gui, 128, 66, 7).title("gui.rs_ctr.dsp_cfg.name", 0.5f).background(new ResourceLocation("rs_ctr", "textures/gui/small.png"), 80, 31);
        new TextField((GuiCompGroup)frame, 112, 7, 8, 16, 20, () -> this.title, t -> gui.sendPkt(new Object[]{(byte)5, t})).allowFormat().tooltip("gui.rs_ctr.label");
        new TextField((GuiCompGroup)frame, 75, 7, 45, 29, 12, () -> this.unit, t -> gui.sendPkt(new Object[]{(byte)4, t})).allowFormat().tooltip("gui.rs_ctr.unit");
        new TextField((GuiCompGroup)frame, 64, 7, 56, 42, 12, () -> Integer.toString(this.max), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)1, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.max");
        new TextField((GuiCompGroup)frame, 64, 7, 56, 51, 12, () -> Integer.toString(this.min), t -> {
            try {
                gui.sendPkt(new Object[]{(byte)0, Integer.parseInt(t)});
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr.min");
        new Button((GuiCompGroup)frame, 20, 9, 7, 28, 3, () -> Math.floorMod(this.exp, 3), s -> gui.sendPkt(new Object[]{(byte)2, (byte)(s + Math.floorDiv(this.exp, 3) * 3)})).texture(227, 36).tooltip("gui.rs_ctr.uscale");
        new Button((GuiCompGroup)frame, 9, 9, 31, 28, 8, () -> (this.exp + 12) / 3, s -> gui.sendPkt(new Object[]{(byte)2, (byte)(s * 3 - 12 + Math.floorMod(this.exp, 3))})).texture(247, 0).tooltip("gui.rs_ctr.uscale");
        return frame;
    }

    public void handleAction(PacketBuffer pkt, EntityPlayerMP sender) throws Exception {
        switch (pkt.readByte()) {
            case 0: {
                this.min = pkt.readInt();
                break;
            }
            case 1: {
                this.max = pkt.readInt();
                break;
            }
            case 2: {
                this.exp = pkt.readByte();
                break;
            }
            case 4: {
                this.unit = pkt.func_150789_c(32);
                break;
            }
            case 5: {
                this.title = pkt.func_150789_c(32);
                break;
            }
            default: {
                return;
            }
        }
        this.host.markDirty(3);
    }
}

