/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.gui;

import cd4017be.lib.Gui.comp.Button;
import cd4017be.lib.Gui.comp.GuiCompGroup;
import cd4017be.lib.Gui.comp.GuiFrame;
import cd4017be.lib.Gui.comp.IGuiComp;
import cd4017be.lib.util.TooltipUtil;
import cd4017be.rscpl.editor.BoundingBox2D;
import cd4017be.rscpl.editor.GateType;
import cd4017be.rscpl.gui.Category;
import cd4017be.rscpl.gui.GateTextureHandler;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;

public class GatePalette
extends GuiFrame {
    private static final ResourceLocation TEX = new ResourceLocation("rs_ctr", "textures/gui/palette.png");
    private final Consumer<GateType> pick;
    private final Category[] tabs;
    private int openTab;

    public GatePalette(GuiFrame parent, Category[] tabs, int x, int y, Consumer<GateType> pick) {
        super(parent, 162, 76, tabs.length);
        this.tabs = tabs;
        this.pick = pick;
        this.background(TEX, 0, 0);
        this.titleY = -11;
        this.openTab = -1;
        for (int i = 0; i < tabs.length; ++i) {
            if (tabs[i] == null) continue;
            if (this.openTab < 0) {
                this.openTab = i;
            }
            int j = i;
            this.add((IGuiComp)new Button((GuiCompGroup)this, 16, 18, 1 + 16 * i, 57, 0, () -> this.openTab == j ? 0 : 1, b -> {
                this.openTab = j;
            }).texture(162, 0).tooltip("gategroup." + tabs[i].name.replace(':', '.')));
            tabs[i].arrange((this.w - 2) / 4, (this.h - 20) / 4);
        }
        this.position(x, y);
    }

    public void drawOverlay(int mx, int my) {
        GateType t;
        if (my >= this.y + 58) {
            super.drawOverlay(mx, my);
        } else if (this.openTab >= 0 && (t = this.tabs[this.openTab].get((mx - this.x - 1) / 4, (my - this.y - 1) / 4)) != null) {
            this.drawTooltip(this.getTooltip(t), mx, my);
        }
    }

    protected String getTooltip(GateType t) {
        return TooltipUtil.translate((String)("gate." + t.name.replace(':', '.')));
    }

    public void drawBackground(int mx, int my, float t) {
        this.bound = false;
        super.drawBackground(mx, my, t);
        this.bindTexture(GateTextureHandler.GATE_ICONS_LOC);
        this.bound = true;
        int i = 0;
        int x = this.x + 1;
        int y = this.y + 59;
        while (i < this.tabs.length) {
            if (this.tabs[i] != null) {
                GateTextureHandler.drawIcon(this.getDraw(), x, y, 16, 16, this.tabs[i].getIcon(), this.zLevel);
            }
            ++i;
            x += 16;
        }
        int x2 = this.x + 3;
        int y2 = this.y + 1;
        if (this.openTab >= 0) {
            for (BoundingBox2D<GateType> bb : this.tabs[this.openTab].instructions) {
                GateTextureHandler.drawIcon(this.getDraw(), x2 + bb.x0 * 4, y2 + bb.y0 * 4, bb.width() * 4 - 4, bb.height() * 4, ((GateType)bb.owner).getIcon(), this.zLevel);
            }
        }
        this.drawNow();
    }

    public boolean mouseIn(int mx, int my, int b, byte d) {
        if (my >= this.y + 56) {
            return super.mouseIn(mx, my, b, d);
        }
        if (this.openTab < 0) {
            return true;
        }
        GateType t = this.tabs[this.openTab].get((mx - this.x - 1) / 4, (my - this.y - 1) / 4);
        this.pick.accept(t);
        return true;
    }
}

