/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rscpl.util;

import java.util.Arrays;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagShort;

public class StateBuffer {
    public final NBTTagCompound nbt;

    public StateBuffer() {
        this.nbt = new NBTTagCompound();
    }

    public StateBuffer(NBTTagCompound nbt) {
        this.nbt = nbt;
    }

    public StateBuffer set(String key, byte value) {
        this.nbt.func_74774_a(key, value);
        return this;
    }

    public StateBuffer set(String key, short value) {
        this.nbt.func_74777_a(key, value);
        return this;
    }

    public StateBuffer set(String key, int value) {
        this.nbt.func_74768_a(key, value);
        return this;
    }

    public StateBuffer set(String key, long value) {
        this.nbt.func_74772_a(key, value);
        return this;
    }

    public StateBuffer set(String key, float value) {
        this.nbt.func_74776_a(key, value);
        return this;
    }

    public StateBuffer set(String key, double value) {
        this.nbt.func_74780_a(key, value);
        return this;
    }

    public StateBuffer set(String key, byte[] value) {
        this.nbt.func_74773_a(key, value);
        return this;
    }

    public StateBuffer set(String key, short[] value) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < value.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagShort(value[i]));
        }
        this.nbt.func_74782_a(key, (NBTBase)list);
        return this;
    }

    public StateBuffer set(String key, int[] value) {
        this.nbt.func_74783_a(key, value);
        return this;
    }

    public StateBuffer set(String key, float[] value) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < value.length; ++i) {
            list.func_74742_a((NBTBase)new NBTTagFloat(value[i]));
        }
        this.nbt.func_74782_a(key, (NBTBase)list);
        return this;
    }

    public byte getByte(String key) {
        return this.nbt.func_74771_c(key);
    }

    public short getShort(String key) {
        return this.nbt.func_74765_d(key);
    }

    public int getInt(String key) {
        return this.nbt.func_74762_e(key);
    }

    public long getLong(String key) {
        return this.nbt.func_74763_f(key);
    }

    public float getFloat(String key) {
        return this.nbt.func_74760_g(key);
    }

    public double getDouble(String key) {
        return this.nbt.func_74769_h(key);
    }

    public void getArr(String key, byte[] arr) {
        byte[] buf = this.nbt.func_74770_j(key);
        int n = Math.min(buf.length, arr.length);
        System.arraycopy(buf, 0, arr, 0, n);
        Arrays.fill(arr, n, arr.length, (byte)0);
    }

    public void getArr(String key, short[] arr) {
        int n = arr.length;
        if (this.nbt.func_150297_b(key, 11)) {
            byte[] buf = this.nbt.func_74770_j(key);
            n = Math.min(buf.length / 2, n);
            int j = 0;
            for (int i = 0; i < n; ++i) {
                arr[i] = (short)(buf[j++] << 8 | buf[j++] & 0xFF);
            }
        } else {
            NBTTagList list = this.nbt.func_150295_c(key, 2);
            n = Math.min(list.func_74745_c(), n);
            for (int i = 0; i < n; ++i) {
                arr[i] = (short)list.func_186858_c(i);
            }
        }
        Arrays.fill(arr, n, arr.length, (short)0);
    }

    public void getArr(String key, int[] arr) {
        int[] buf = this.nbt.func_74759_k(key);
        int n = Math.min(buf.length, arr.length);
        System.arraycopy(buf, 0, arr, 0, n);
        Arrays.fill(arr, n, arr.length, 0);
    }

    public void getArr(String key, float[] arr) {
        NBTTagList list = this.nbt.func_150295_c(key, 5);
        int n = Math.min(list.func_74745_c(), arr.length);
        for (int i = 0; i < n; ++i) {
            arr[i] = list.func_150308_e(i);
        }
        Arrays.fill(arr, n, arr.length, 0.0f);
    }
}

