/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2;

import cd4017be.api.grid.Link;
import cd4017be.lib.config.ModConfig;
import cd4017be.rs_ctr2.part.SolarCell;
import java.util.function.Consumer;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;

public class ConfigServer
extends ModConfig
implements Consumer<FMLServerStartingEvent> {
    public final ForgeConfigSpec.IntValue battery_cap;
    public final ForgeConfigSpec.IntValue solar_power;
    public final ForgeConfigSpec.IntValue move_item;
    public final ForgeConfigSpec.IntValue move_fluid;
    public final ForgeConfigSpec.IntValue craft;
    public final ForgeConfigSpec.IntValue block_break;
    public final ForgeConfigSpec.IntValue hardness_break;
    public final ForgeConfigSpec.IntValue item_place;
    public final ForgeConfigSpec.DoubleValue daytime;
    public final ForgeConfigSpec.IntValue rec_data;
    public final ForgeConfigSpec.IntValue rec_power;
    public final ForgeConfigSpec.IntValue rec_item;
    public final ForgeConfigSpec.IntValue rec_fluid;
    public final ForgeConfigSpec.IntValue rec_block;
    public final ForgeConfigSpec.IntValue memory_size;
    public final ForgeConfigSpec.IntValue item_buffer_size;
    public final ForgeConfigSpec.IntValue fluid_buffer_size;
    public final ForgeConfigSpec.IntValue pipe_limit;
    public final ForgeConfigSpec.IntValue frame_range;
    public final ForgeConfigSpec.IntValue device_range;

    protected ConfigServer() {
        super(ModConfig.Type.SERVER);
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        b.push("energy");
        this.battery_cap = b.comment("RF capacity per battery cell.").defineInRange("battery_cap", 16000, 1, 0x1FFFFFF);
        this.solar_power = b.comment("RF generated per cell over 8 ticks at maximum sun illumination.").defineInRange("solar_power", 8, 0, 0x1FFFFFF);
        this.daytime = b.comment("Integrated fraction of the day with full sun illumination.").defineInRange("daytime", 0.3888888888888889, 0.0, 1.0);
        this.move_item = b.comment("RF required to move 64 items.").defineInRange("move_item", 64, 0, Integer.MAX_VALUE);
        this.move_fluid = b.comment("RF required to move one bucket of liquid.").defineInRange("move_fluid", 64, 0, Integer.MAX_VALUE);
        this.craft = b.comment("RF required per crafting operation.").defineInRange("craft", 20, 0, Integer.MAX_VALUE);
        this.item_place = b.comment("RF required per placement/interact operation.").defineInRange("item_place", 50, 0, Integer.MAX_VALUE);
        this.block_break = b.comment("Base RF required to break a block.").defineInRange("block_break", 100, 0, Integer.MAX_VALUE);
        this.hardness_break = b.comment("Additional RF required per block hardness value.").defineInRange("hardness_cost", 40, 0, Integer.MAX_VALUE);
        b.pop();
        this.memory_size = b.comment("memory size in bits per cell.").defineInRange("memory_size", 256, 32, 16384);
        this.item_buffer_size = b.comment("max stack size per buffer cell").defineInRange("buffer_stacksize", 400, 1, 15625);
        this.fluid_buffer_size = b.comment("max mB fluid per buffer cell").defineInRange("buffer_fluidcap", 1000, 1, 0x1FFFFFF);
        this.pipe_limit = b.comment("Maximum distance Block Interaction Pipes can be extended.").defineInRange("max_pipe_length", 256, 0, 30000000);
        this.frame_range = b.comment("Maximum distance between Frame blocks.").defineInRange("max_frame_distance", 96, 0, 255);
        this.device_range = b.comment("Maximum distance between Frame and machine.").defineInRange("max_device_distance", 16, 0, 255);
        b.push("recursion_limit");
        this.rec_data = b.defineInRange("data", Link.REC_DATA, 0, 64);
        this.rec_power = b.defineInRange("power", Link.REC_POWER, 0, 64);
        this.rec_item = b.defineInRange("power", Link.REC_ITEM, 0, 64);
        this.rec_fluid = b.defineInRange("power", Link.REC_FLUID, 0, 64);
        this.rec_block = b.defineInRange("block", Link.REC_BLOCK, 0, 64);
        b.pop();
        this.finish(b);
        MinecraftForge.EVENT_BUS.addListener((Consumer)this);
    }

    @Override
    public void accept(FMLServerStartingEvent t) {
        Link.REC_DATA = (Integer)this.rec_data.get();
        Link.REC_POWER = (Integer)this.rec_power.get();
        Link.REC_ITEM = (Integer)this.rec_item.get();
        Link.REC_FLUID = (Integer)this.rec_fluid.get();
        Link.REC_BLOCK = (Integer)this.rec_block.get();
        SolarCell.INV_DAY_LENGHT = 1.0f / (float)((Double)this.daytime.get() * 18000.0);
    }
}

