/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.container;

import cd4017be.lib.container.AdvancedContainer;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.network.StateSyncAdv;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.container.gui.GuiRAM;
import cd4017be.rs_ctr2.part.Memory;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.function.IntSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerMemory
extends AdvancedContainer {
    private static final int[] SYNC_FORMAT = new int[66];
    private final Memory part;
    private byte page;
    public static final byte A_PAGE = 0;
    public static final byte A_SET_MEM = 1;
    public static final byte A_DOWNLOAD = 2;
    public static final byte A_UPLOAD = 3;

    public ContainerMemory(int id, PlayerInventory inv, PacketBuffer pkt) {
        this(id, inv, (Memory)null);
    }

    public ContainerMemory(int id, PlayerInventory inv, Memory part) {
        super(Content.mEMORY, id, inv, StateSyncAdv.of((part == null ? 1 : 0) != 0, (int[])SYNC_FORMAT, (int)1, (Object[])new Object[0]), 0);
        this.part = part;
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player.func_70089_S() && (this.part == null || this.part.host != null);
    }

    protected void detectChanges(BitSet chng) {
        int[] data = this.part.data;
        int l = data.length;
        int i = 0;
        int j = this.page << 6;
        while (i < 64) {
            this.sync.setInt(i, j < l ? data[j] : 0);
            ++i;
            ++j;
        }
        this.sync.setShort(64, l);
        this.sync.setByte(65, (int)this.page);
    }

    protected void writeChanges(BitSet chng, PacketBuffer pkt) {
        if (chng.get(this.sync.objIdxOfs())) {
            pkt.func_150787_b(0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void readChanges(BitSet chng, PacketBuffer pkt) throws Exception {
        if (!chng.get(this.sync.objIdxOfs())) {
            return;
        }
        int l = pkt.func_150792_a();
        if (l == 0) {
            return;
        }
        byte[] mem = new byte[l << 2];
        pkt.readBytes(mem);
        Screen gui = Minecraft.func_71410_x().field_71462_r;
        if (gui instanceof GuiRAM) {
            ((GuiRAM)gui).processDownload(mem);
        }
    }

    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        int[] memory = this.part.data;
        switch (pkt.readByte()) {
            case 0: {
                this.page = pkt.readByte();
                if (this.page <= 0) {
                    this.page = 0;
                    break;
                }
                if (this.page < memory.length + 63 >> 6) break;
                this.page = (byte)Math.max(0, (memory.length + 63 >> 6) - 1);
                break;
            }
            case 1: {
                int i = pkt.readShort() & 0xFFFF;
                byte v = pkt.readByte();
                int bit = (i & 7) * 4;
                int idx = i >> 3;
                if (idx >= memory.length) break;
                memory[idx] = v << bit | memory[idx] & ~(15 << bit);
                break;
            }
            case 2: {
                this.sync.clear();
                this.sync.set(0, null);
                pkt = GuiNetworkHandler.preparePacket((Container)this);
                this.sync.write((ByteBuf)pkt);
                pkt.func_150787_b(memory.length);
                for (int i : memory) {
                    pkt.writeIntLE(i);
                }
                GuiNetworkHandler.GNH_INSTANCE.sendToPlayer(pkt, (ServerPlayerEntity)this.inv.field_70458_d);
                break;
            }
            case 3: {
                int l = pkt.readUnsignedShort();
                if (l > memory.length) {
                    return;
                }
                for (int i = 0; i < l; ++i) {
                    memory[i] = pkt.readIntLE();
                }
                Arrays.fill(memory, l, memory.length, 0);
                sender.func_146105_b((ITextComponent)new TranslationTextComponent("msg.rs_ctr2.import_succ"), false);
                break;
            }
            default: {
                return;
            }
        }
    }

    public IntSupplier page() {
        return this.sync.intGetter(65, false);
    }

    public IntSupplier size() {
        return this.sync.intGetter(64, false);
    }

    public IntBuffer get() {
        return ((ByteBuffer)this.sync.buffer().clear()).asIntBuffer();
    }

    static {
        Arrays.fill(SYNC_FORMAT, 4);
        ContainerMemory.SYNC_FORMAT[64] = 2;
        ContainerMemory.SYNC_FORMAT[65] = 1;
        StateSyncAdv.sequence((int[])SYNC_FORMAT);
    }
}

