/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.container.gui;

import cd4017be.lib.text.TooltipUtil;
import cd4017be.rs_ctr2.container.gui.RAMImageFormat;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.network.PacketBuffer;

public class BMPImage
implements RAMImageFormat {
    public BMPImage() {
        REGISTRY.add(this);
    }

    @Override
    public boolean applies(String filename) {
        return filename.endsWith(".bmp");
    }

    @Override
    public String infoMessage(boolean export, String file, int w, int h, int bits) {
        return export ? TooltipUtil.format((String)"msg.rs_ctr2.encode_bmp", (Object[])new Object[]{w, h, file}) : TooltipUtil.format((String)"msg.rs_ctr2.decode_bmp", (Object[])new Object[]{file});
    }

    @Override
    public void importFile(FileInputStream fis, PacketBuffer data, int[] wh, int bits, int cap) throws IOException {
        PNG_IMAGE.importFile(fis, data, wh, 1, cap);
    }

    @Override
    public void exportFile(FileOutputStream fos, ByteBuffer data, int w, int h, int bits) throws IOException {
        h = Math.min(h, ((data.capacity() << 3) - 1) / w + 1);
        int offset = 62;
        int line = w + 31 >> 3 & 0xFFFFFFFC;
        int sizeIm = line * h;
        ByteBuffer header = ByteBuffer.allocate(62).order(ByteOrder.LITTLE_ENDIAN);
        header.putShort((short)19778).putInt(62 + sizeIm).putInt(0).putInt(62).putInt(40).putInt(w).putInt(-h).putShort((short)1).putShort((short)1).putInt(0).putInt(sizeIm).putInt(0).putInt(0).putInt(0).putInt(0);
        header.putInt(0).putInt(0xFFFFFF);
        header.flip();
        fos.getChannel().write(header);
        int ds = (line << 3) - w;
        if (ds == 0) {
            int i;
            if (sizeIm < data.capacity()) {
                data.limit(sizeIm);
            }
            while (data.hasRemaining()) {
                i = Integer.reverse(data.getInt());
                fos.write(i);
                fos.write(i >> 8);
                fos.write(i >> 16);
                fos.write(i >> 24);
            }
            for (i = sizeIm - data.limit(); i > 0; --i) {
                fos.write(0);
            }
        } else {
            int shift = 0;
            long carry = 0L;
            for (int y = h - 1; y >= 0; --y) {
                for (int x = (line >> 2) - 1; x >= 0; --x) {
                    carry <<= 32;
                    if (data.hasRemaining() && (x > 0 || shift + ds < 32)) {
                        carry |= (long)data.getInt() & 0xFFFFFFFFL;
                    }
                    int i = Integer.reverse((int)(carry >> shift));
                    fos.write(i);
                    fos.write(i >> 8);
                    fos.write(i >> 16);
                    fos.write(i >> 24);
                }
                if ((shift += ds) < 32) continue;
                shift -= 32;
                carry >>>= 32;
            }
        }
    }
}

