/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.container.gui;

import cd4017be.lib.container.AdvancedContainer;
import cd4017be.lib.gui.ModularGui;
import cd4017be.lib.gui.comp.Button;
import cd4017be.lib.gui.comp.FileBrowser;
import cd4017be.lib.gui.comp.GuiCompBase;
import cd4017be.lib.gui.comp.GuiCompGroup;
import cd4017be.lib.gui.comp.GuiFrame;
import cd4017be.lib.gui.comp.TextField;
import cd4017be.lib.network.GuiNetworkHandler;
import cd4017be.lib.text.TooltipUtil;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.container.ContainerMemory;
import cd4017be.rs_ctr2.container.gui.RAMImageFormat;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fml.loading.FMLPaths;

public class GuiRAM
extends ModularGui<ContainerMemory> {
    private static final ResourceLocation TEX = Main.rl("textures/gui/ram.png");
    private static final File dir = FMLPaths.GAMEDIR.get().resolve("rs_ctr2/memory").toFile().getAbsoluteFile();
    private int fmtW;
    private int fmtH;
    private int mode;
    private final IntSupplier size;
    private final IntSupplier page;
    private final IntBuffer data;

    public GuiRAM(ContainerMemory cont, PlayerInventory player, ITextComponent title) {
        super((AdvancedContainer)cont, player, title);
        this.size = cont.size();
        this.page = cont.page();
        this.data = cont.get();
        GuiFrame frame = new GuiFrame((ModularGui)this, 160, 135, 5).background(TEX, 0, 0).title("gui.rs_ctr2.ram", 0.5f);
        new Editor((GuiCompGroup)frame, 144, 102, 8, 16);
        new Button((GuiCompGroup)frame, 18, 9, 7, 119, 0, null, i -> {
            dir.mkdirs();
            File file = new File(dir, "ram.hex");
            GuiFrame fb = new FileBrowser(frame, this::importData, null).setFile(file).title("gui.rs_ctr2.import_file", 0.5f);
            fb.init(this.field_230708_k_, this.field_230709_l_, 0.0f, this.field_230712_o_);
            fb.position(8, 8);
        }).tooltip("gui.rs_ctr2.import_file");
        new Button((GuiCompGroup)frame, 18, 9, 25, 119, 0, null, i -> this.sendPkt(new Object[]{(byte)2})).tooltip("gui.rs_ctr2.export_file");
        new TextField((GuiCompGroup)frame, 48, 7, 54, 120, 8, () -> Integer.toString(this.fmtW), t -> {
            try {
                this.fmtW = Integer.parseInt(t);
                if (this.fmtW <= 0) {
                    this.fmtW = 1;
                } else if (this.fmtW > 4096) {
                    this.fmtW = 4096;
                }
                this.fmtH = Math.max(1, Math.min(4096, this.addrSize() / this.fmtW));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr2.fmt_w");
        new TextField((GuiCompGroup)frame, 48, 7, 104, 120, 8, () -> Integer.toString(this.fmtH), t -> {
            try {
                this.fmtH = Integer.parseInt(t);
                if (this.fmtH <= 0) {
                    this.fmtH = 1;
                } else if (this.fmtH > 4096) {
                    this.fmtH = 4096;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }).tooltip("gui.rs_ctr2.fmt_h");
        this.compGroup = frame;
        this.mode = 0;
        this.fmtW = 16;
        this.fmtH = this.size.getAsInt() >> 4;
    }

    public int addrSize() {
        return this.size.getAsInt() << this.mode;
    }

    public int bits() {
        return 1 << 5 - this.mode;
    }

    public int get(int addr) {
        int bits = this.bits();
        return this.data.get(addr >> this.mode & 0x3F) >>> addr * bits;
    }

    public void processDownload(byte[] mem) {
        ByteBuffer data = ByteBuffer.wrap(mem);
        dir.mkdirs();
        File file = new File(dir, "ram.hex");
        GuiFrame f = new FileBrowser((GuiFrame)this.compGroup, fb -> {
            fb.close();
            this.exportData(fb.getFile(), data);
        }, null).setFile(file).title("gui.rs_ctr2.export_file", 0.5f);
        f.init(this.field_230708_k_, this.field_230709_l_, 0.0f, this.field_230712_o_);
        f.position(8, 8);
    }

    private void exportData(File file, ByteBuffer data) {
        if (!file.getAbsolutePath().startsWith(dir.getAbsolutePath())) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr2.dir_invalid", (Object[])new Object[]{file}));
            return;
        }
        String name = file.getName();
        RAMImageFormat fmt = RAMImageFormat.get(name);
        try (FileOutputStream fos = new FileOutputStream(file);){
            int bits = this.bits();
            this.sendChat(fmt.infoMessage(true, name, this.fmtW, this.fmtH, bits));
            fmt.exportFile(fos, data, this.fmtW, this.fmtH, bits);
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr2.no_file", (Object[])new Object[]{file}));
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendChat("\u00a74" + e.toString());
            return;
        }
        this.sendChat(TooltipUtil.format((String)"msg.rs_ctr2.export_succ", (Object[])new Object[0]));
    }

    private void importData(FileBrowser fb) {
        fb.close();
        File file = fb.getFile();
        String name = file.getName();
        RAMImageFormat fmt = RAMImageFormat.get(name);
        try (FileInputStream fis = new FileInputStream(file);){
            int bits = this.bits();
            this.sendChat(fmt.infoMessage(false, name, this.fmtW, this.fmtH, bits));
            PacketBuffer buff = GuiNetworkHandler.preparePacket((Container)this.field_147002_h);
            buff.writeByte(3);
            int[] wh = new int[]{this.fmtW, this.fmtH};
            fmt.importFile(fis, buff, wh, bits, this.size.getAsInt());
            this.fmtW = wh[0];
            this.fmtH = wh[1];
            GuiNetworkHandler.GNH_INSTANCE.sendToServer(buff);
        }
        catch (FileNotFoundException e) {
            this.sendChat(TooltipUtil.format((String)"msg.rs_ctr2.no_file", (Object[])new Object[]{file}));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendChat("\u00a74" + e.toString());
        }
    }

    class Editor
    extends GuiCompBase<GuiCompGroup> {
        int cursor;

        public Editor(GuiCompGroup parent, int w, int h, int x, int y) {
            super(parent, w, h, x, y);
            this.cursor = -1;
        }

        public void drawOverlay(MatrixStack mstack, int mx, int my) {
            if (my - this.y > 6) {
                return;
            }
            GuiRAM.this.compGroup.drawTooltip(mstack, TooltipUtil.format((String)"gui.rs_ctr2.ram.layout", (Object[])new Object[]{32 >> GuiRAM.this.mode, GuiRAM.this.addrSize()}), mx, my);
        }

        public void drawBackground(MatrixStack mstack, int mx, int my, float t) {
            int bits = GuiRAM.this.mode;
            GuiRAM.this.compGroup.drawRect(mstack, this.x, this.y, 0, 232 + bits * 6, 128, 6);
            this.print(mstack, 128, 0, GuiRAM.this.addrSize() - 1, 4, 4);
            int p = GuiRAM.this.page.getAsInt() << 6;
            int addr = p << bits;
            int l = (Math.min(64, GuiRAM.this.size.getAsInt() - p + 3) >> 2) * 6;
            int j = 0;
            for (int i = 6; i <= l; i += 6) {
                this.print(mstack, 128, i, addr + j, 4, 5);
                int k = (4 << bits) - 1;
                while (k >= 0) {
                    this.print(mstack, k << 5 - bits, i, GuiRAM.this.get(j), 8 >> bits, 0);
                    --k;
                    ++j;
                }
            }
            if (this.cursor >= 0) {
                int y = this.y + 6 + (this.cursor >> 5) * 6;
                int x = this.x + 124 - (this.cursor & 0x1F) * 4;
                int v = (GuiRAM.this.data.get(this.cursor >> 3 & 0x3F) >> (this.cursor << 2 & 0x1C) & 0xF) * 8;
                if ((this.cursor & 7 >> bits) == 0) {
                    v += 4;
                }
                GuiRAM.this.compGroup.drawRect(mstack, x, y, v, 190, 4, 6);
            }
        }

        private void print(MatrixStack mstack, int x, int y, int v, int w, int c) {
            c = 196 + c * 6;
            GuiRAM.this.compGroup.drawRect(mstack, x += this.x + 4 * (w - 1), y += this.y, (v & 0xF) * 8 + 4, c, 4, 6);
            --w;
            while (w > 0) {
                GuiRAM.this.compGroup.drawRect(mstack, x -= 4, y, ((v >>= 4) & 0xF) * 8, c, 4, 6);
                --w;
            }
        }

        public boolean keyIn(char c, int k, byte d) {
            byte v;
            switch (k) {
                case 265: {
                    this.cursor -= 31;
                }
                case 262: {
                    if (--this.cursor < 0) {
                        int n = this.cursor = this.mvPage(-1) ? this.cursor + 512 : 0;
                    }
                    if (Screen.func_231173_s_()) {
                        this.cursor &= ~(7 >> GuiRAM.this.mode);
                    }
                    return true;
                }
                case 264: {
                    this.cursor += 31;
                }
                case 263: {
                    if (Screen.func_231173_s_()) {
                        this.cursor |= 7 >> GuiRAM.this.mode;
                    }
                    if (++this.cursor > 511) {
                        this.cursor = this.mvPage(1) ? this.cursor - 512 : 511;
                    }
                    return true;
                }
                case 266: {
                    this.mvPage(-1);
                    return true;
                }
                case 267: {
                    this.mvPage(1);
                    return true;
                }
                case 268: {
                    this.cursor = 0;
                    GuiRAM.this.sendPkt(new Object[]{(byte)0, (byte)0});
                    return true;
                }
                case 269: {
                    this.cursor = 511;
                    GuiRAM.this.sendPkt(new Object[]{(byte)0, (byte)127});
                    return true;
                }
                case 48: {
                    v = 0;
                    break;
                }
                case 49: {
                    v = 1;
                    break;
                }
                case 50: {
                    v = 2;
                    break;
                }
                case 51: {
                    v = 3;
                    break;
                }
                case 52: {
                    v = 4;
                    break;
                }
                case 53: {
                    v = 5;
                    break;
                }
                case 54: {
                    v = 6;
                    break;
                }
                case 55: {
                    v = 7;
                    break;
                }
                case 56: {
                    v = 8;
                    break;
                }
                case 57: {
                    v = 9;
                    break;
                }
                case 65: {
                    v = 10;
                    break;
                }
                case 66: {
                    v = 11;
                    break;
                }
                case 67: {
                    v = 12;
                    break;
                }
                case 68: {
                    v = 13;
                    break;
                }
                case 69: {
                    v = 14;
                    break;
                }
                case 70: {
                    v = 15;
                    break;
                }
                default: {
                    return false;
                }
            }
            GuiRAM.this.sendPkt(new Object[]{(byte)1, (short)(this.cursor | GuiRAM.this.page.getAsInt() << 9), v});
            if (Screen.func_231172_r_()) {
                this.cursor += 31;
            }
            if (++this.cursor > 511) {
                this.cursor = this.mvPage(1) ? this.cursor - 512 : 511;
            }
            return true;
        }

        public boolean mouseIn(int mx, int my, int b, byte d) {
            mx = 31 - (mx - this.x) / 4;
            my = (my - this.y) / 6 - 1;
            if (d == 0) {
                if (my < 0) {
                    GuiRAM.this.mode = GuiRAM.this.mode + (b == 0 ? 1 : 3) & 3;
                }
                this.cursor = my * 32 + (mx < 0 ? 0 : mx);
            } else if (d == 3) {
                this.mvPage(-b);
            }
            return true;
        }

        private boolean mvPage(int incr) {
            if ((incr += GuiRAM.this.page.getAsInt()) < 0 || incr >= GuiRAM.this.size.getAsInt() + 63 >> 6) {
                return false;
            }
            GuiRAM.this.sendPkt(new Object[]{(byte)0, (byte)incr});
            return true;
        }

        public boolean focus() {
            return true;
        }

        public void unfocus() {
            this.cursor = -1;
        }
    }
}

