/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.container.gui;

import cd4017be.lib.text.TooltipUtil;
import cd4017be.rs_ctr2.container.gui.RAMImageFormat;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.ImageIO;
import net.minecraft.network.PacketBuffer;

public final class PNGImage
implements RAMImageFormat {
    private final int[] COLORS4;
    private final int[] COLORS16;

    public PNGImage() {
        REGISTRY.add(this);
        this.COLORS4 = new int[]{-16777216, -16776961, -16711936, -65536};
        this.COLORS16 = new int[]{-16777216, -16777025, -16728320, -16733526, -4259840, -5635926, -4227072, -5592406, -11184811, -11184641, -11141291, -16711681, -43691, -65281, -256, -1};
    }

    @Override
    public boolean applies(String filename) {
        return filename.endsWith(".png");
    }

    @Override
    public String infoMessage(boolean export, String file, int w, int h, int bits) {
        return export ? TooltipUtil.format((String)"msg.rs_ctr2.encode_img", (Object[])new Object[]{w, h, bits, file}) : TooltipUtil.format((String)"msg.rs_ctr2.decode_img", (Object[])new Object[]{bits, file});
    }

    @Override
    public void importFile(FileInputStream fis, PacketBuffer data, int[] wh, int bits, int cap) throws IOException {
        BufferedImage img = ImageIO.read(fis);
        int w = wh[0] = img.getWidth();
        int h = wh[1] = img.getHeight();
        h = Math.min(h, (cap << 5) / bits / w);
        data.writeShort(w * h * bits + 31 >> 5);
        switch (bits) {
            case 1: {
                int x = 0;
                int y = 0;
                while (y < h) {
                    int acc = 0;
                    for (int j = 0; j < 32; ++j) {
                        if ((img.getRGB(x, y) & 0x808080) != 0) {
                            acc |= 1 << j;
                        }
                        if (++x < w) continue;
                        x = 0;
                        if (++y >= h) break;
                    }
                    data.writeIntLE(acc);
                }
                break;
            }
            case 2: {
                int x = 0;
                int y = 0;
                while (y < h) {
                    int acc = 0;
                    for (int j = 0; j < 32; j += 2) {
                        acc |= 4 - (Integer.numberOfLeadingZeros(img.getRGB(x, y) & 0x808080) >> 3) << j;
                        if (++x < w) continue;
                        x = 0;
                        if (++y >= h) break;
                    }
                    data.writeIntLE(acc);
                }
                break;
            }
            case 4: {
                int x = 0;
                int y = 0;
                while (y < h) {
                    int acc = 0;
                    for (int j = 0; j < 32; j += 4) {
                        int c = img.getRGB(x, y);
                        acc |= (((c & 0x7F) + (c >> 8 & 0x7F) + (c >> 16 & 0x7F)) / 191 << 3 | c >> 7 & 1 | c >> 14 & 2 | c >> 21 & 4) << j;
                        if (++x < w) continue;
                        x = 0;
                        if (++y >= h) break;
                    }
                    data.writeIntLE(acc);
                }
                break;
            }
            case 8: {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        data.writeByte((int)((byte)img.getRGB(x, y)));
                    }
                }
                int i = w * h;
                while ((i & 3) != 0) {
                    data.writeByte(0);
                    ++i;
                }
                break;
            }
            case 16: {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        data.writeShortLE((int)((short)img.getRGB(x, y)));
                    }
                }
                if ((w * h & 1) == 0) break;
                data.writeShortLE(0);
                break;
            }
            case 32: {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        data.writeIntLE(img.getRGB(x, y));
                    }
                }
                break;
            }
        }
    }

    @Override
    public void exportFile(FileOutputStream fos, ByteBuffer data, int w, int h, int bits) throws IOException {
        BufferedImage img = new BufferedImage(w, h, 2);
        data.order(ByteOrder.LITTLE_ENDIAN);
        h = Math.min(h, (data.capacity() << 3) / bits / w);
        switch (bits) {
            case 1: {
                int x = 0;
                int y = 0;
                block8: while (y < h) {
                    int acc = data.getInt();
                    for (int j = 0; j < 32; ++j) {
                        img.setRGB(x, y, (acc >> j & 1) != 0 ? -1 : -16777216);
                        if (++x < w) continue;
                        x = 0;
                        if (++y >= h) continue block8;
                    }
                }
                break;
            }
            case 2: {
                int x = 0;
                int y = 0;
                block10: while (y < h) {
                    int acc = data.getInt();
                    for (int j = 0; j < 32; j += 2) {
                        img.setRGB(x, y, this.COLORS4[acc >> j & 3]);
                        if (++x < w) continue;
                        x = 0;
                        if (++y >= h) continue block10;
                    }
                }
                break;
            }
            case 4: {
                int x = 0;
                int y = 0;
                block12: while (y < h) {
                    int acc = data.getInt();
                    for (int j = 0; j < 32; j += 4) {
                        img.setRGB(x, y, this.COLORS16[acc >> j & 0xF]);
                        if (++x < w) continue;
                        x = 0;
                        if (++y >= h) continue block12;
                    }
                }
                break;
            }
            case 8: {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        img.setRGB(x, y, 0xFF000000 | data.get() & 0xFF);
                    }
                }
                break;
            }
            case 16: {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        img.setRGB(x, y, 0xFF000000 | data.getShort() & 0xFFFF);
                    }
                }
                break;
            }
            case 32: {
                for (int y = 0; y < h; ++y) {
                    for (int x = 0; x < w; ++x) {
                        img.setRGB(x, y, data.getInt());
                    }
                }
                break;
            }
        }
        ImageIO.write((RenderedImage)img, "PNG", fos);
    }
}

