/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.item;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.lib.item.GridItem;
import cd4017be.rs_ctr2.part.MultiBlock;
import java.util.function.IntFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;

public class MultiblockItem<T extends MultiBlock<T>>
extends GridItem {
    private final IntFunction<T> factory;

    public MultiblockItem(Item.Properties p, IntFunction<T> factory) {
        super(p);
        this.factory = factory;
    }

    public T createPart() {
        return (T)((MultiBlock)this.factory.apply(-1));
    }

    public ActionResultType onInteract(IGridHost grid, ItemStack stack, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == null) {
            return ActionResultType.PASS;
        }
        int pos = IGridHost.target((BlockRayTraceResult)hit, (boolean)true);
        if (pos < 0) {
            return ActionResultType.PASS;
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        MultiBlock part = (MultiBlock)this.factory.apply(pos);
        Object other = part.findAdjacent(grid, part.bounds);
        if (!(other == null ? grid.addPart((GridPart)part) : ((MultiBlock)other).addVoxel(pos))) {
            return ActionResultType.FAIL;
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }
}

