/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.item;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.IGridPortHolder;
import cd4017be.lib.item.DocumentedItem;
import cd4017be.lib.text.TooltipUtil;
import cd4017be.rs_ctr2.api.IProbeInfo;
import java.util.Objects;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class SignalProbeItem
extends DocumentedItem
implements IGridItem {
    public SignalProbeItem(Item.Properties p) {
        super(p);
    }

    public GridPart createPart() {
        return null;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return world.func_175625_s(pos) instanceof IGridHost;
    }

    public ActionResultType onInteract(IGridHost grid, ItemStack stack, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == null) {
            return ActionResultType.PASS;
        }
        int pos = IGridHost.target((BlockRayTraceResult)hit, (boolean)false);
        if (pos < 0) {
            return ActionResultType.PASS;
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74774_a("gp", (byte)pos);
        nbt.func_74772_a("bp", hit.func_216350_a().func_218275_a());
        return ActionResultType.SUCCESS;
    }

    public ActionResultType func_195939_a(ItemUseContext use) {
        if (use.func_195991_k().field_72995_K) {
            return ActionResultType.CONSUME;
        }
        CompoundNBT nbt = use.func_195996_i().func_196082_o();
        nbt.func_74774_a("gp", (byte)-1);
        nbt.func_74772_a("bp", use.func_195995_a().func_218275_a());
        return ActionResultType.SUCCESS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean sel) {
        if (!sel || world.field_72995_K) {
            return;
        }
        CompoundNBT nbt = stack.func_196082_o();
        BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("bp"));
        if (!pos.func_218137_a((IPosition)entity.func_213303_ch(), 8.0)) {
            nbt.func_82580_o("ports");
            nbt.func_82580_o("info");
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        byte gp = nbt.func_74771_c("gp");
        if (gp >= 0 && te instanceof IGridHost) {
            IGridHost host = (IGridHost)te;
            long m = 1L << gp;
            GridPart part = host.findPart(p -> (p.bounds & m) != 0L && p.ports.length > 0);
            if (part != null) {
                SignalProbeItem.packInfo(nbt, part);
                return;
            }
            nbt.func_74774_a("gp", (byte)-1);
        }
        SignalProbeItem.packInfo(nbt, te);
    }

    private static void packInfo(CompoundNBT nbt, Object info) {
        Object[] args;
        int i;
        if (info instanceof IGridPortHolder) {
            nbt.func_218657_a("ports", (INBT)((IGridPortHolder)info).extPorts().serializeNBT());
        } else if (info instanceof GridPart) {
            short[] ports = ((GridPart)info).ports;
            int[] arr = new int[ports.length];
            for (i = 0; i < ports.length; ++i) {
                arr[i] = ports[i] & 0xFFFF | (((GridPart)info).isMaster(i) ? -1879048192 : 0x10000000);
            }
            nbt.func_74783_a("ports", arr);
        } else {
            nbt.func_74783_a("ports", ArrayUtils.EMPTY_INT_ARRAY);
        }
        Object[] objectArray = args = info instanceof IProbeInfo ? ((IProbeInfo)info).stateInfo() : null;
        if (args == null || args.length < 1) {
            nbt.func_82580_o("info");
            return;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a("key", Objects.toString(args[0]));
        for (i = 1; i < args.length; ++i) {
            String key = Integer.toString(i - 1);
            Object o = args[i];
            if (o instanceof Double || o instanceof Float) {
                tag.func_74780_a(key, ((Number)o).doubleValue());
                continue;
            }
            if (o instanceof Long) {
                tag.func_74772_a(key, ((Long)o).longValue());
                continue;
            }
            if (o instanceof Number) {
                tag.func_74768_a(key, ((Number)o).intValue());
                continue;
            }
            if (o instanceof Boolean) {
                tag.func_74757_a(key, ((Boolean)o).booleanValue());
                continue;
            }
            tag.func_74778_a(key, Objects.toString(o));
        }
        nbt.func_218657_a("info", (INBT)tag);
    }

    public static int[] readPorts(CompoundNBT nbt) {
        INBT tag = nbt.func_74781_a("ports");
        if (tag instanceof IntArrayNBT) {
            return ((IntArrayNBT)tag).func_150302_c();
        }
        if (tag instanceof LongArrayNBT) {
            long[] arr = ((LongArrayNBT)tag).func_197652_h();
            int[] ports = new int[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                ports[i] = (int)(arr[i] >> 32);
            }
            return ports;
        }
        return null;
    }

    public static String readInfo(CompoundNBT nbt) {
        if ((nbt = nbt.func_74775_l("info")).isEmpty()) {
            return TooltipUtil.translate((String)"state.rs_ctr2.none");
        }
        String key = nbt.func_74779_i("key");
        Object[] args = new Object[nbt.func_186856_d() - 1];
        block9: for (String k : nbt.func_150296_c()) {
            try {
                int i = Integer.parseInt(k);
                if (i >= args.length) continue;
                INBT tag = nbt.func_74781_a(k);
                switch (tag.func_74732_a()) {
                    case 1: {
                        args[i] = ((NumberNBT)tag).func_150290_f() != 0;
                        continue block9;
                    }
                    case 3: {
                        args[i] = ((NumberNBT)tag).func_150287_d();
                        continue block9;
                    }
                    case 4: {
                        args[i] = ((NumberNBT)tag).func_150291_c();
                        continue block9;
                    }
                    case 6: {
                        args[i] = ((NumberNBT)tag).func_150286_g();
                        continue block9;
                    }
                    case 8: {
                        args[i] = TooltipUtil.translate((String)((StringNBT)tag).func_150285_a_());
                        continue block9;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return TooltipUtil.format((String)key, (Object[])args);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.func_77973_b() != newStack.func_77973_b();
    }

    public boolean func_195938_a(BlockState state, World world, BlockPos pos, PlayerEntity player) {
        if (!world.field_72995_K && player.func_184812_l_()) {
            world.func_180495_p(pos).func_196942_a(world, pos, player);
        }
        return false;
    }
}

