/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.item;

import cd4017be.api.grid.Link;
import cd4017be.lib.text.TooltipUtil;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.rs_ctr2.item.OrientedPartItem;
import cd4017be.rs_ctr2.part.Wireless;
import cd4017be.rs_ctr2.part.WirelessMaster;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class WirelessItem
extends OrientedPartItem<Wireless> {
    public final WirelessItem pair;
    public final int type;

    public WirelessItem(Item.Properties p, Supplier<Wireless> factory, int type) {
        super(p, factory);
        this.type = type;
        this.pair = new WirelessItem(p, this);
    }

    private WirelessItem(Item.Properties p, WirelessItem item) {
        super(p, null);
        this.type = item.type;
        this.pair = item;
    }

    public void register(IForgeRegistry<Item> registry, ResourceLocation main, ResourceLocation master) {
        registry.registerAll((IForgeRegistryEntry[])new Item[]{(Item)this.setRegistryName(main), (Item)this.pair.setRegistryName(master)});
    }

    public Rarity func_77613_e(ItemStack stack) {
        return WirelessItem.hasLink(stack) ? Rarity.RARE : Rarity.COMMON;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (WirelessItem.hasLink(stack)) {
            tooltip.add((ITextComponent)TooltipUtil.cFormat((String)"item.wireless.link", (Object[])new Object[]{stack.func_77978_p().func_74762_e("link")}));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    @Override
    public Wireless createPart() {
        return this.factory != null ? (Wireless)this.factory.get() : new WirelessMaster(this);
    }

    @Override
    protected void onPlace(Wireless part, ItemStack stack, PlayerEntity player) {
        if (WirelessItem.hasLink(stack)) {
            part.link = stack.func_77978_p().func_74762_e("link");
        } else {
            ItemStack stack1 = new ItemStack((IItemProvider)this.pair);
            part.link = Link.newId();
            stack1.func_196082_o().func_74768_a("link", part.link);
            ItemFluidUtil.dropStack((ItemStack)stack1, (Entity)player);
        }
        super.onPlace(part, stack, player);
    }

    public static boolean hasLink(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_150297_b("link", 3);
    }
}

