/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.port.IEnergyAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.part.MultiBlock;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class Battery
extends MultiBlock<Battery>
implements IGate,
IEnergyAccess {
    ISignalReceiver out = ISignalReceiver.NOP;
    @Sync
    public int energy;
    @Sync
    public int state;
    @Sync
    public boolean active;
    int cap;
    public static final ResourceLocation MODEL = Main.rl("part/battery");

    public Battery(int pos) {
        super(pos);
    }

    public Item item() {
        return Content.battery;
    }

    public GridPart setHost(IGridHost host) {
        if (this.active && host != null) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        return super.setHost(host);
    }

    @Override
    protected void onBoundsChange() {
        this.cap = Long.bitCount(this.bounds) * (Integer)Main.SERVER_CFG.battery_cap.get();
        this.energy = Math.min(this.energy, this.cap);
    }

    @Override
    protected ActionResultType onInteract(PlayerEntity player, boolean client) {
        if (client) {
            return ActionResultType.CONSUME;
        }
        player.func_146105_b((ITextComponent)new TranslationTextComponent("msg.rs_ctr2.battery", new Object[]{this.energy, this.cap, Long.bitCount(this.bounds)}), true);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected ActionResultType createPort(IGridItem item, short port, boolean client) {
        if (item == Content.power_cable) {
            if (client) {
                return ActionResultType.CONSUME;
            }
            IGridHost host = this.host;
            host.removePart((GridPart)this);
            this.ports = ArrayUtils.add((short[])this.ports, (short)((short)(port | 0x1000)));
            host.addPart((GridPart)this);
            return ActionResultType.SUCCESS;
        }
        if (item == Content.data_cable) {
            if (client) {
                return ActionResultType.CONSUME;
            }
            IGridHost host = this.host;
            host.removePart((GridPart)this);
            if (this.ports.length == 0 || (this.ports[0] & 0xF000) != 0) {
                short[] arr = this.ports;
                this.ports = new short[arr.length + 1];
                System.arraycopy(arr, 0, this.ports, 1, arr.length);
            }
            this.ports[0] = port;
            host.addPart((GridPart)this);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected Battery splitOff(long b1, long b) {
        Battery part = new Battery(-1);
        part.energy = (int)((long)this.energy * (long)Long.bitCount(b1) / (long)Long.bitCount(b));
        this.energy -= part.energy;
        return part;
    }

    @Override
    protected short[] merge(Battery other) {
        int i0;
        this.energy += other.energy;
        short[] p = other.ports;
        short[] ports = this.ports;
        int n = i0 = p.length > 0 && (p[0] & 0xF000) == 0 ? 1 : 0;
        if (p.length <= i0) {
            return ports;
        }
        int l = ports.length;
        ports = Arrays.copyOf(ports, l + p.length - i0);
        System.arraycopy(p, i0, ports, l, p.length - i0);
        return ports;
    }

    public Object getHandler(int port) {
        return this;
    }

    public void setHandler(int port, Object handler) {
        this.out = ISignalReceiver.of((Object)handler);
        this.out.updateInput(this.state);
    }

    public boolean isMaster(int channel) {
        return channel == 0 && this.ports.length > 0 && (this.ports[0] & 0xF000) == 0;
    }

    public int transferEnergy(int amount, boolean test, int rec) {
        if (amount == 0) {
            return 0;
        }
        if (amount < -this.energy) {
            amount = -this.energy;
        } else if (amount > this.cap - this.energy) {
            amount = this.cap - this.energy;
        }
        if (!test) {
            this.energy += amount;
            if (!this.active) {
                this.active = true;
                GateUpdater.GATE_UPDATER.add((IGate)this);
            }
        }
        return amount;
    }

    public boolean evaluate() {
        this.active = false;
        if (this.host == null) {
            return false;
        }
        this.state = this.energy;
        return true;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.battery", this.energy, this.cap};
    }

    public void latchOut() {
        this.out.updateInput(this.state);
    }

    public boolean dissassemble(World world, BlockPos pos) {
        this.energy = 0;
        return true;
    }

    @Override
    protected ResourceLocation model() {
        return MODEL;
    }
}

