/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IDynamicPart;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.render.GridModels;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.math.Linalg;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.container.ContainerButton;
import cd4017be.rs_ctr2.part.Switch;
import cd4017be.rs_ctr2.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Button
extends OrientedPart
implements IDynamicPart,
IGate,
IUnnamedContainerProvider,
IPlayerPacketReceiver {
    ISignalReceiver out = ISignalReceiver.NOP;
    @Sync(to=-2147483641)
    public byte delay = (byte)5;
    @Sync(to=7)
    public byte state;
    @Sync(to=7, type=Sync.Type.Enum)
    public DyeColor color = DyeColor.RED;
    public static final ResourceLocation ON = Main.rl("part/button_on");
    public static final ResourceLocation OFF = Main.rl("part/button_off");

    public Button() {
        super(1);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 0);
    }

    public Item item() {
        return Content.button;
    }

    public byte getLayer() {
        return -1;
    }

    public Object getHandler(int port) {
        return null;
    }

    public void setHandler(int port, Object handler) {
        this.out = ISignalReceiver.of((Object)handler);
        this.out.updateInput(this.state != 0 ? -1 : 0);
    }

    public boolean isMaster(int port) {
        return true;
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        boolean crouch = player.func_213453_ef();
        if (hand == null || crouch && !player.func_184586_b(hand).func_190926_b()) {
            return super.onInteract(player, hand, hit, pos);
        }
        DyeColor color = Utils.heldColor(player, hand);
        return Utils.serverAction(player, color != null ? () -> {
            this.color = color;
            this.host.onPartChange();
        } : (crouch ? () -> player.func_213829_a((INamedContainerProvider)this) : () -> {
            if (this.state == 0) {
                GateUpdater.GATE_UPDATER.add((IGate)this);
                this.state = (byte)-1;
            } else {
                this.state = this.delay;
            }
        }));
    }

    public boolean evaluate() {
        return this.host != null;
    }

    public void latchOut() {
        if (this.state == -1) {
            this.state = this.delay;
            this.changeState(-1);
        } else {
            this.state = (byte)(this.state - 1);
            if (this.state == 0) {
                this.changeState(0);
                return;
            }
        }
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    private void changeState(int state) {
        float[] vec = Linalg.sca((int)3, (float[])Linalg.dadd((int)3, (float[])Button.vec((int)Button.pos((int)this.pos, (Orientation)this.orient)), (float)0.5f), (float)0.25f);
        BlockPos bp = this.host.pos();
        this.host.world().func_184148_a(null, (double)bp.func_177958_n() + (double)vec[0], (double)bp.func_177956_o() + (double)vec[1], (double)bp.func_177952_p() + (double)vec[2], (SoundEvent)(state < 0 ? Content.BUTTON_PRESs : Content.BUTTON_RELEASe), SoundCategory.BLOCKS, 3.0f, 2.0f);
        this.host.updateDisplay();
        this.out.updateInput(state);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ResourceLocation model() {
        return Switch.BASE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack ms, IRenderTypeBuffer rtb, int light, int overlay, float t, long opaque) {
        if ((this.bounds & (opaque ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return;
        }
        ms.func_227860_a_();
        this.transform(ms);
        GridModels.draw((ResourceLocation)(this.state != 0 ? ON : OFF), (MatrixStack.Entry)ms.func_227866_c_(), (IVertexBuilder)rtb.getBuffer(RenderType.func_228639_c_()), (int)this.color.func_218388_g(), (int)(this.state != 0 ? 240 : light), (int)overlay);
        ms.func_227865_b_();
    }

    public void readSync(PacketBuffer pkt) {
        this.state = pkt.readByte();
    }

    public void writeSync(PacketBuffer pkt, boolean init) {
        pkt.writeByte((int)this.state);
    }

    public ContainerButton createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerButton(id, inv, (GridPart)this);
    }

    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        int d = Math.min(Math.max(pkt.readByte() & 0xFF, 1), 250);
        this.delay = (byte)d;
        if ((this.state + 1 & 0xFF) - 1 > d) {
            this.state = this.delay;
        }
    }
}

