/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.IPortHolder;
import cd4017be.api.grid.IWire;
import cd4017be.lib.render.MicroBlockFace;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.math.Linalg;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Cable
extends GridPart
implements IWire {
    private static final Item[] ITEMS = new Item[]{Content.data_cable, Content.power_cable, Content.item_cable, Content.fluid_cable, Content.block_cable, Items.field_190931_a, Items.field_190931_a, Items.field_190931_a};
    public static final ResourceLocation[] MODELS = new ResourceLocation[]{Main.rl("part/data_cable"), Main.rl("part/power_cable"), Main.rl("part/item_cable"), Main.rl("part/fluid_cable"), Main.rl("part/block_cable"), null, null, null};

    public Cable() {
        super(2);
    }

    public Cable(int pos, Direction d1, Direction d2, int type) {
        this();
        this.bounds = 1L << pos;
        this.ports[0] = Cable.port((int)pos, (Direction)d1, (int)type);
        this.ports[1] = Cable.port((int)pos, (Direction)d2, (int)type);
    }

    public Item item() {
        return ITEMS[this.ports[0] >> 12 & 7];
    }

    public ItemStack asItemStack() {
        return new ItemStack((IItemProvider)this.item(), Long.bitCount(this.bounds));
    }

    public byte getLayer() {
        return -1;
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        if (hand != null) {
            return ActionResultType.PASS;
        }
        if (!player.field_70170_p.field_72995_K && player.func_184614_ca().func_77973_b() instanceof IGridItem) {
            this.remove(pos);
            if (!player.func_184812_l_()) {
                ItemFluidUtil.dropStack((ItemStack)new ItemStack((IItemProvider)this.item()), (Entity)player);
            }
        }
        return ActionResultType.CONSUME;
    }

    public void merge(GridPart other) {
        if (!(other instanceof Cable)) {
            return;
        }
        short[] tp = this.ports;
        short[] op = other.ports;
        if (tp[0] == op[1]) {
            tp[0] = op[0];
        } else if (tp[1] == op[0]) {
            tp[1] = op[1];
        } else if (tp[0] == op[0]) {
            tp[0] = op[1];
        } else if (tp[1] == op[1]) {
            tp[1] = op[0];
        } else {
            return;
        }
        this.bounds |= other.bounds;
        other.host.removePart(other);
    }

    public void addTo(IGridHost host) {
        IPortHolder.Port p = host.findPort((GridPart)this, this.ports[0]);
        if (p != null ? !p.isMaster() : (p = host.findPort((GridPart)this, this.ports[1])) != null && p.isMaster()) {
            short p0 = this.ports[0];
            this.ports[0] = this.ports[1];
            this.ports[1] = p0;
        }
        host.addPart((GridPart)this);
    }

    public void remove(int pos) {
        Cable part;
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        long b = this.bounds & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
        if (b == 0L) {
            host.removeIfEmpty();
            return;
        }
        long f0 = Cable.path(b, this.ports[0]);
        long f1 = Cable.path(b, this.ports[1]);
        if (f0 != 0L) {
            part = new Cable();
            if (f1 == f0) {
                f1 = 0L;
                part.ports[1] = this.ports[1];
            } else {
                part.ports[1] = Cable.portNear(f0, pos, this.ports[1] >> 12);
            }
            part.ports[0] = this.ports[0];
            part.bounds = f0;
            b &= f0 ^ 0xFFFFFFFFFFFFFFFFL;
            host.addPart((GridPart)part);
        }
        if (f1 != 0L) {
            part = new Cable();
            part.ports[0] = Cable.portNear(f1, pos, this.ports[0] >> 12);
            part.ports[1] = this.ports[1];
            part.bounds = f1;
            b &= f1 ^ 0xFFFFFFFFFFFFFFFFL;
            host.addPart((GridPart)part);
        }
        if (b != 0L) {
            ItemFluidUtil.dropStack((ItemStack)new ItemStack((IItemProvider)this.item(), Long.bitCount(b)), (World)host.world(), (BlockPos)host.pos());
        }
        host.removeIfEmpty();
    }

    private static short portNear(long b, int pos, int type) {
        Direction d;
        if ((3 & pos) != 0 && (b >>> pos - 1 & 1L) != 0L) {
            d = Direction.WEST;
        } else if ((3 & ~pos) != 0 && (b >>> pos + 1 & 1L) != 0L) {
            d = Direction.EAST;
        } else if ((0xC & pos) != 0 && (b >>> pos - 4 & 1L) != 0L) {
            d = Direction.DOWN;
        } else if ((0xC & ~pos) != 0 && (b >>> pos + 4 & 1L) != 0L) {
            d = Direction.UP;
        } else if ((0x30 & pos) != 0 && (b >>> pos - 16 & 1L) != 0L) {
            d = Direction.NORTH;
        } else if ((0x30 & ~pos) != 0 && (b >>> pos + 16 & 1L) != 0L) {
            d = Direction.SOUTH;
        } else {
            pos = Long.numberOfTrailingZeros(b);
            d = Direction.NORTH;
        }
        return Cable.port((int)pos, (Direction)d, (int)type);
    }

    private static long path(long b, short port) {
        int p = IGridHost.posOfport((int)port);
        if ((p < 0 || (b >> p & 1L) == 0L) && (p = IGridHost.posOfport((int)(port - 273))) < 0) {
            return 0L;
        }
        return Cable.floodFill((long)b, (long)(1L << p));
    }

    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        nbt.func_74772_a("bounds", this.bounds);
        nbt.func_74768_a("ports", this.ports[0] & 0xFFFF | this.ports[1] << 16);
    }

    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        this.bounds = nbt.func_74763_f("bounds");
        int port = nbt.func_74762_e("ports");
        this.ports[0] = (short)port;
        this.ports[1] = (short)(port >>> 16);
    }

    public Object getHandler(int port) {
        IPortHolder.Port p = this.host.findPort((GridPart)this, this.ports[port ^ 1]);
        return p == null ? null : p.getHandler();
    }

    public void setHandler(int port, Object handler) {
        IPortHolder.Port p = this.host.findPort((GridPart)this, this.ports[port ^ 1]);
        if (p != null) {
            p.setHandler(handler);
        }
    }

    public boolean isMaster(int channel) {
        return channel != 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillModel(JitBakedModel model, long opaque) {
        MicroBlockFace[] faces = MicroBlockFace.facesOf((Object)MODELS[this.ports[0] >> 12 & 7]);
        ArrayList quads = model.inner();
        long b = this.bounds;
        long visible = opaque ^ 0xFFFFFFFFFFFFFFFFL;
        Cable.drawPort(quads, faces, this.ports[0], b, visible);
        Cable.drawPort(quads, faces, this.ports[1], b, visible);
        Cable.drawStrips(quads, faces, b & b >>> 1 & 0x7777777777777777L, visible, 0);
        Cable.drawStrips(quads, faces, b & b >>> 4 & 0xFFF0FFF0FFF0FFFL, visible, 1);
        Cable.drawStrips(quads, faces, b & b >>> 16 & 0xFFFFFFFFFFFFL, visible, 2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawStrips(List<BakedQuad> quads, MicroBlockFace[] faces, long line, long visible, int ax) {
        int d;
        int s = 1 << ax + ax;
        int n = d = ax == 0 ? 2 : ax - 1;
        while (line != 0L) {
            int p = Long.numberOfTrailingZeros(line);
            int n2 = 1;
            long m = 1L << p;
            long l = m << s;
            while ((line & l) != 0L) {
                m |= l;
                l <<= s;
                ++n2;
            }
            line &= m ^ 0xFFFFFFFFFFFFFFFFL;
            if (((m | m << s) & visible) == 0L) continue;
            float[] vec = Linalg.sca((int)3, (float[])Linalg.dadd((int)3, (float[])Cable.vec((int)p), (float)0.25f), (float)0.25f);
            float[] size = new float[]{0.125f, 0.125f, 0.125f};
            int n3 = ax;
            size[n3] = size[n3] + (float)n2 * 0.25f;
            for (int i = 0; i < 6; ++i) {
                if (i >> 1 == d || faces[i] == null) continue;
                quads.add(faces[i].makeRect(vec, size));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void drawPort(List<BakedQuad> quads, MicroBlockFace[] faces, int port, long b, long visible) {
        boolean visible1;
        int p0 = IGridHost.posOfport((int)port);
        int p1 = IGridHost.posOfport((int)(port - 273));
        boolean visible0 = p0 < 0 || (visible >>> p0 & 1L) != 0L;
        boolean bl = visible1 = p1 < 0 || (visible >>> p1 & 1L) != 0L;
        if ((b >>> p0 & 1L) == 0L) {
            p0 = -1;
        }
        if ((b >>> p1 & 1L) == 0L) {
            p1 = -1;
        }
        if (p0 < 0 ^ p1 >= 0 || !(visible0 | visible1)) {
            return;
        }
        if (p0 >= 0) {
            boolean v = visible0;
            visible0 = visible1;
            visible1 = v;
        } else {
            p0 = p1;
        }
        int ax = Integer.numberOfTrailingZeros(0x111 & ~port) >> 2;
        if (ax >= 3) {
            return;
        }
        float[] vec = Linalg.dadd((int)3, (float[])Cable.vec((int)p0), (float)0.25f);
        float[] size = new float[]{0.5f, 0.5f, 0.5f};
        if (p1 < 0) {
            int n = ax;
            vec[n] = vec[n] - 0.2505f;
        }
        size[ax] = 0.751f;
        Linalg.sca((int)3, (float[])vec, (float)0.25f);
        Linalg.sca((int)3, (float[])size, (float)0.25f);
        int d = p1 >>> 31 | (ax == 0 ? 4 : ax - 1 << 1);
        for (int i = 0; i < 6; ++i) {
            if (i == d || faces[i] == null || !(i == (d ^ 1) ? visible0 : visible1)) continue;
            quads.add(faces[i].makeRect(vec, size));
        }
    }

    public boolean merge(IGridHost other) {
        IPortHolder.Port p0 = other.findPort((GridPart)this, this.ports[0]);
        IPortHolder.Port p1 = other.findPort((GridPart)this, this.ports[1]);
        Cable c0 = p0 != null && p0.host instanceof Cable ? (Cable)p0.host : null;
        Cable c1 = p1 != null && p1.host instanceof Cable ? (Cable)p1.host : null;
        int i = 1;
        if (c0 == null) {
            if (c1 == null) {
                return true;
            }
            p0 = p1;
            c0 = c1;
            c1 = null;
            i = 0;
        }
        c0.bounds |= this.bounds;
        if (c1 != null) {
            c0.bounds |= c1.bounds;
            c0.ports[p0.channel] = c1.ports[p1.channel ^ 1];
            other.removePart((GridPart)c1);
        } else {
            c0.ports[p0.channel] = this.ports[i];
        }
        return false;
    }

    public boolean canRotate() {
        return true;
    }

    public void rotate(int steps) {
        Cable.rotate((short[])this.ports, (int)steps);
        super.rotate(steps);
    }

    public boolean canMove(Direction d, int n) {
        long m = Cable.mask((int)d.ordinal(), (int)n);
        long b0 = this.bounds & m;
        long b1 = this.bounds & (m ^ 0xFFFFFFFFFFFFFFFFL);
        return b0 == 0L || b1 == 0L || Long.bitCount(Cable.outline((long)b0) & b1) == 1;
    }

    public GridPart move(Direction d, int n) {
        GridPart part = super.move(d, n);
        if (part == null || part == this) {
            Cable.move((short[])this.ports, (Direction)d, (int)n, (part == this ? 1 : 0) != 0);
            return part;
        }
        Cable.move((short[])part.ports, (Direction)d, (int)n, (boolean)true);
        Cable.move((short[])this.ports, (Direction)d, (int)n, (boolean)false);
        int xor = 0;
        long b = part.bounds;
        switch (d) {
            case DOWN: {
                b >>>= 12;
                xor = 128;
                break;
            }
            case UP: {
                b <<= 12;
                xor = 128;
                break;
            }
            case NORTH: {
                b >>>= 48;
                xor = 2048;
                break;
            }
            case SOUTH: {
                b <<= 48;
                xor = 2048;
                break;
            }
            case WEST: {
                b >>>= 3;
                xor = 8;
                break;
            }
            case EAST: {
                b <<= 3;
                xor = 8;
            }
        }
        short p0 = Cable.port((int)Long.numberOfTrailingZeros(b & this.bounds & FACES[d.ordinal()]), (Direction)d, (int)(this.ports[0] >> 12));
        short p1 = (short)(p0 ^ xor);
        if (Cable.overflow(this.ports[0])) {
            this.ports[0] = p0;
            part.ports[1] = p1;
        } else {
            this.ports[1] = p0;
            part.ports[0] = p1;
        }
        return part;
    }

    private static boolean overflow(short p) {
        return ((p & 0x888) * 7 >> 3 & p) != 0;
    }

    protected Cable copy(long bounds) {
        Cable c = new Cable();
        c.bounds = bounds;
        c.ports[0] = this.ports[0];
        c.ports[1] = this.ports[1];
        return c;
    }
}

