/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.part.SignalGate;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;

public class Clock
extends SignalGate
implements ISignalReceiver {
    @Sync
    public int dt;
    @Sync
    public int t;

    public Clock() {
        super(2);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 0);
        this.setPort(1, pos, Direction.SOUTH, 0);
    }

    public boolean evaluate() {
        this.active = false;
        if (this.host == null || this.dt < 0) {
            return false;
        }
        if (++this.t >= this.dt) {
            this.t = 0;
            this.state = this.dt == 0 ? 0 : ~this.state;
        }
        return true;
    }

    @Override
    public void latchOut() {
        if (this.t == 0) {
            super.latchOut();
        }
        if (this.dt > 0) {
            this.update();
        }
    }

    public Object getHandler(int port) {
        return port == 1 ? this : null;
    }

    public Item item() {
        return Content.clock;
    }

    public void updateInput(int value, int rec) {
        this.dt = value;
        if (value > 0) {
            this.update();
        }
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.clock", this.state, this.dt, this.t};
    }
}

