/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.part.SignalGate;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;

public class Counter
extends SignalGate
implements ISignalReceiver {
    ISignalReceiver clkOut = ISignalReceiver.NOP;
    @Sync
    public int max;
    @Sync
    public int clk;
    @Sync
    public int clkO;

    public Counter() {
        super(4);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 0);
        this.setPort(1, pos, Direction.WEST, 0);
        this.setPort(2, pos, Direction.SOUTH, 0);
        this.setPort(3, pos, Direction.EAST, 0);
    }

    public Item item() {
        return Content.counter;
    }

    public ISignalReceiver getHandler(int port) {
        return port == 2 ? this::updateLimit : (port == 3 ? this : null);
    }

    @Override
    public void setHandler(int port, Object handler) {
        if (port == 1) {
            this.clkOut = ISignalReceiver.of((Object)handler);
            this.clkOut.updateInput(this.clkO);
        } else {
            super.setHandler(port, handler);
        }
    }

    @Override
    public boolean isMaster(int channel) {
        return channel < 2;
    }

    public void updateLimit(int value, int rec) {
        this.max = value;
        if (this.max > 0 & this.max <= 0) {
            this.update();
        }
    }

    public void updateInput(int value, int rec) {
        if ((value & ~this.clk) != 0 || value == 0 && this.clk != 0) {
            this.update();
        }
        this.clk = value;
    }

    public boolean evaluate() {
        this.active = false;
        if (this.host == null) {
            return false;
        }
        if (this.clk != 0) {
            ++this.state;
        }
        if (this.state >= this.max) {
            if (this.max > 0) {
                this.clkO = this.clk;
            }
            this.state = 0;
        } else {
            this.clkO = 0;
        }
        return true;
    }

    @Override
    public void latchOut() {
        super.latchOut();
        this.clkOut.updateInput(this.clkO);
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.counter", this.state, this.clkO, this.max, this.clk};
    }
}

