/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.util.Orientation;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ModelLoader;

public abstract class ExtendablePart
extends OrientedPart {
    public ExtendablePart(int ports) {
        super(ports);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos + (pos >> 6 & 3));
    }

    public ItemStack asItemStack() {
        return new ItemStack((IItemProvider)this.item(), (this.pos >> 6 & 3) + 1);
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        Direction r;
        ItemStack stack;
        if (hand == null || (stack = player.func_184586_b(hand)).func_77973_b() != this.item()) {
            return super.onInteract(player, hand, hit, pos);
        }
        Direction d = hit.func_216354_b();
        if (d != (r = this.orient.r) && d != r.func_176734_d()) {
            return ActionResultType.PASS;
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        pos = this.pos;
        if (d == r) {
            if ((pos & 3) + (pos >> 6 & 3) >= 3) {
                return ActionResultType.FAIL;
            }
            pos += 64;
        } else {
            if ((pos & 3) == 0) {
                return ActionResultType.FAIL;
            }
            pos += 63;
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        this.set(pos, this.orient);
        host.addPart((GridPart)this);
        return ActionResultType.SUCCESS;
    }

    protected ResourceLocation model() {
        ResourceLocation res = this.item().getRegistryName();
        return new ResourceLocation(res.func_110624_b(), "part/" + res.func_110623_a() + (this.pos >> 6 & 3));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(Item item) {
        ResourceLocation res = item.getRegistryName();
        for (int i = 0; i < 4; ++i) {
            ModelLoader.addSpecialModel((ResourceLocation)new ResourceLocation(res.func_110624_b(), "part/" + res.func_110623_a() + i));
        }
    }
}

