/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.port.IFluidAccess;
import cd4017be.lib.network.Sync;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.part.MultiBlock;
import cd4017be.rs_ctr2.util.Utils;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.ArrayUtils;

public class FluidBuffer
extends MultiBlock<FluidBuffer>
implements IFluidAccess,
IFluidHandler {
    @Sync
    public FluidStack content = FluidStack.EMPTY;
    int max;
    public static final ResourceLocation MODEL = Main.rl("part/fluid_buffer");

    public FluidBuffer(int pos) {
        super(pos);
    }

    public Item item() {
        return Content.fluid_buffer;
    }

    public Object getHandler(int port) {
        return this;
    }

    public void setHandler(int port, Object handler) {
    }

    public boolean isMaster(int port) {
        return false;
    }

    public void getContent(ObjIntConsumer<FluidStack> inspector, int rec) {
        inspector.accept(this.content, this.max);
    }

    public int transfer(int amount, Predicate<FluidStack> filter, ToIntFunction<FluidStack> target, int rec) {
        int n = this.content.getAmount();
        if ((amount = Math.min(amount, n)) <= 0 || !filter.test(this.content)) {
            return 0;
        }
        this.content.setAmount(amount);
        amount = target.applyAsInt(this.content);
        this.content.setAmount(n - amount);
        return amount;
    }

    public int insert(FluidStack stack, int rec) {
        int n = this.content.getAmount();
        int m = Math.min(this.max - n, stack.getAmount());
        if (m == 0) {
            return 0;
        }
        if (n == 0) {
            this.content = new FluidStack(stack, m);
        } else if (this.content.isFluidEqual(stack)) {
            this.content.grow(m);
        } else {
            return 0;
        }
        return m;
    }

    public FluidBuffer setHost(IGridHost host) {
        super.setHost(host);
        if (host == null) {
            return this;
        }
        if (this.content.getAmount() > this.max) {
            this.content.setAmount(this.max);
        }
        return this;
    }

    @Override
    protected void onBoundsChange() {
        int n = Long.bitCount(this.bounds);
        this.max = n * (Integer)Main.SERVER_CFG.fluid_buffer_size.get();
        this.setHost(this.host);
    }

    @Override
    protected ActionResultType createPort(IGridItem item, short port, boolean client) {
        if (item != Content.fluid_cable) {
            return ActionResultType.PASS;
        }
        if (client) {
            return ActionResultType.CONSUME;
        }
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        this.ports = ArrayUtils.add((short[])this.ports, (short)((short)(port | 0x3000)));
        host.addPart((GridPart)this);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected ActionResultType onInteract(PlayerEntity player, boolean client) {
        ItemStack stack = player.func_184614_ca();
        return Utils.serverAction(client, stack.func_190926_b() ? () -> player.func_146105_b((ITextComponent)new TranslationTextComponent("msg.rs_ctr2.fluid_buffer", new Object[]{this.content.getAmount(), this.max, this.content.getDisplayName(), Long.bitCount(this.bounds)}), true) : () -> FluidUtil.interactWithFluidHandler((PlayerEntity)player, (Hand)Hand.MAIN_HAND, (IFluidHandler)this));
    }

    @Override
    protected FluidBuffer splitOff(long splitBounds, long thisBounds) {
        FluidBuffer other = new FluidBuffer(-1);
        if (!this.content.isEmpty()) {
            int n = (int)((long)this.content.getAmount() * (long)Long.bitCount(splitBounds) / (long)Long.bitCount(thisBounds));
            other.content = this.content.copy();
            other.content.setAmount(n);
            this.content.shrink(n);
        }
        return other;
    }

    @Override
    public FluidBuffer findAdjacent(IGridHost host, long b) {
        long o = FluidBuffer.outline((long)b) & (b ^ 0xFFFFFFFFFFFFFFFFL);
        FluidStack stack = this.content;
        return (FluidBuffer)host.findPart(stack.isEmpty() ? p -> (p.bounds & o) != 0L && p instanceof FluidBuffer : p -> {
            if ((p.bounds & o) == 0L || !(p instanceof FluidBuffer)) {
                return false;
            }
            FluidStack stack1 = ((FluidBuffer)p).content;
            return stack1.isEmpty() || stack1.isFluidEqual(stack);
        });
    }

    @Override
    protected short[] merge(FluidBuffer other) {
        this.max += other.max;
        if (this.content.isEmpty()) {
            this.content = other.content;
        } else {
            this.content.grow(other.content.getAmount());
        }
        return ArrayUtils.addAll((short[])this.ports, (short[])other.ports);
    }

    @Override
    protected ResourceLocation model() {
        return MODEL;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.fluid_buffer", '\\' + this.content.getDisplayName().getString(), this.content.getAmount(), this.max};
    }

    public boolean dissassemble(World world, BlockPos pos) {
        this.content = FluidStack.EMPTY;
        return true;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.content;
    }

    public int getTankCapacity(int tank) {
        return this.max;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
        if (action.execute()) {
            return this.insert(stack, 0);
        }
        int n = this.content.getAmount();
        return n == 0 || this.content.isFluidEqual(stack) ? Math.min(this.max - n, stack.getAmount()) : 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.content.isFluidEqual(resource) ? this.drain(resource.getAmount(), action) : FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if ((maxDrain = Math.min(maxDrain, this.content.getAmount())) <= 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = new FluidStack(this.content, maxDrain);
        if (action.execute()) {
            this.content.shrink(maxDrain);
        }
        return stack;
    }
}

