/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.IFluidAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.util.Utils;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFilter
extends OrientedPart
implements IFluidAccess,
ISignalReceiver,
IGate,
Predicate<FluidStack>,
IProbeInfo {
    private Fluid filter = Fluids.field_204541_a;
    IFluidAccess main = IFluidAccess.NOP;
    IFluidAccess rem = IFluidAccess.NOP;
    @Sync
    public byte val;
    @Sync(to=-2147483647)
    public byte idx;
    @Sync
    public boolean active;

    public FluidFilter() {
        super(4);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 3);
        this.setPort(1, pos, Direction.WEST, 0);
        this.setPort(2, pos, Direction.EAST, 3);
        this.setPort(3, pos, Direction.SOUTH, 3);
    }

    public Item item() {
        return Content.fluid_filter;
    }

    public Object getHandler(int port) {
        return this.isMaster(port) ? null : this;
    }

    public void setHandler(int port, Object handler) {
        if (port == 2) {
            this.main = IFluidAccess.of((Object)handler);
        } else if (port == 3) {
            this.rem = IFluidAccess.of((Object)handler);
        }
    }

    public boolean isMaster(int port) {
        return port >= 2;
    }

    public void updateInput(int value, int rec) {
        this.val = (byte)value;
        if (this.val == this.val || this.active) {
            return;
        }
        this.active = true;
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    public boolean evaluate() {
        this.active = false;
        this.idx = this.val;
        return false;
    }

    private Predicate<FluidStack> filter() {
        return this.idx == 0 ? this : (this.idx < 0 ? this.negate() : null);
    }

    @Override
    public boolean test(FluidStack stack) {
        return stack.getFluid() == this.filter;
    }

    public void getContent(ObjIntConsumer<FluidStack> inspector, int rec) {
        if (--rec < 0) {
            return;
        }
        Predicate<FluidStack> filter = this.filter();
        if (filter == null) {
            this.rem.getContent(inspector, rec);
        } else {
            this.main.getContent((stack, n) -> {
                if (filter.test((FluidStack)stack)) {
                    inspector.accept((FluidStack)stack, n);
                }
            }, rec);
        }
    }

    public int transfer(int amount, Predicate<FluidStack> filter, ToIntFunction<FluidStack> target, int rec) {
        if (--rec < 0) {
            return 0;
        }
        Predicate<FluidStack> filter0 = this.filter();
        return filter0 == null ? this.rem.transfer(amount, filter, target, rec) : this.main.transfer(amount, filter0.and(filter), target, rec);
    }

    public int insert(FluidStack stack, int rec) {
        if (--rec < 0) {
            return 0;
        }
        return (this.test(stack) ? this.main : this.rem).insert(stack, rec);
    }

    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        if ((mode & 1) != 0) {
            this.filter = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.func_74779_i("fluid")));
            if (this.filter == null) {
                this.filter = Fluids.field_204541_a;
            }
        }
    }

    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        if ((mode & 1) != 0) {
            nbt.func_74778_a("fluid", this.filter.getRegistryName().toString());
        }
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        if (hand == null || player.func_213453_ef()) {
            return super.onInteract(player, hand, hit, pos);
        }
        ItemStack stack = player.func_184614_ca();
        return Utils.serverAction(player, stack.func_190926_b() ? () -> player.func_146105_b((ITextComponent)new TranslationTextComponent(this.filter.getAttributes().getTranslationKey()), true) : () -> FluidUtil.getFluidHandler((ItemStack)stack).ifPresent(h -> {
            this.filter = h.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getFluid();
        }));
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.fluid_filter", this.val, this.main != IFluidAccess.NOP, this.rem != IFluidAccess.NOP, this.filter.getAttributes().getTranslationKey()};
    }
}

