/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.api.grid.port.IFluidAccess;
import cd4017be.lib.network.Sync;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.part.CapabilityIO;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidIO
extends CapabilityIO<IFluidHandler>
implements IFluidAccess,
IProbeInfo {
    @Sync
    public FluidStack remainder = FluidStack.EMPTY;

    public FluidIO() {
        super(2);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 4);
        this.setPort(1, pos, Direction.SOUTH, 3);
    }

    @Override
    protected Capability<IFluidHandler> capability() {
        return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public Item item() {
        return Content.fluid_io;
    }

    public void getContent(ObjIntConsumer<FluidStack> inspector, int rec) {
        IFluidHandler inv = this.get(null);
        if (inv != null) {
            int l = inv.getTanks();
            for (int i = 0; i < l; ++i) {
                inspector.accept(inv.getFluidInTank(i), inv.getTankCapacity(i));
            }
            return;
        }
        if (this.last == null) {
            return;
        }
        FluidState state = ((ServerWorld)this.last.right).func_204610_c((BlockPos)this.last.left);
        inspector.accept(!state.func_206889_d() ? FluidStack.EMPTY : new FluidStack(state.func_206886_c(), 1000), 1000);
    }

    public int transfer(int amount, Predicate<FluidStack> filter, ToIntFunction<FluidStack> target, int rec) {
        IFluidHandler inv;
        FluidStack stack;
        block11: {
            stack = this.remainder;
            if (!stack.isEmpty()) {
                if (!filter.test(stack)) {
                    return 0;
                }
                int i = target.applyAsInt(amount >= stack.getAmount() ? stack : new FluidStack(stack, amount));
                stack.shrink(i);
                return i;
            }
            inv = this.get(null);
            if (inv == null) {
                if (amount < 1000 || this.last == null) {
                    return 0;
                }
                stack = ItemFluidUtil.drainFluid((World)((World)this.last.right), (BlockPos)((BlockPos)this.last.left), filter);
                if (stack.isEmpty()) {
                    return 0;
                }
                int i = target.applyAsInt(stack);
                if (i < stack.getAmount()) {
                    this.remainder = stack;
                    this.remainder.shrink(i);
                }
                return i;
            }
            stack = inv.drain(amount, IFluidHandler.FluidAction.SIMULATE);
            if (stack.isEmpty()) {
                return 0;
            }
            if (!filter.test(stack)) {
                int l = inv.getTanks();
                for (int i = 0; i < l; ++i) {
                    stack = inv.getFluidInTank(i);
                    if (stack.isEmpty() || !filter.test(stack) || (stack = inv.drain(new FluidStack(stack, amount), IFluidHandler.FluidAction.SIMULATE)).isEmpty()) {
                        continue;
                    }
                    break block11;
                }
                return 0;
            }
        }
        amount = target.applyAsInt(stack);
        stack.setAmount(amount);
        if (amount <= 0) {
            return 0;
        }
        inv.drain(stack, IFluidHandler.FluidAction.EXECUTE);
        return amount;
    }

    public int insert(FluidStack stack, int rec) {
        IFluidHandler inv = this.get(null);
        if (inv != null) {
            return inv.fill(stack, IFluidHandler.FluidAction.EXECUTE);
        }
        int m = this.remainder.isFluidEqual(stack) ? this.remainder.getAmount() : 0;
        stack = stack.copy();
        stack.grow(m);
        if (stack.getAmount() < 1000) {
            return 0;
        }
        if (!ItemFluidUtil.placeFluid((World)((World)this.last.right), (BlockPos)((BlockPos)this.last.left), (FluidStack)stack)) {
            return 0;
        }
        if (m > 0) {
            this.remainder = FluidStack.EMPTY;
        }
        return 1000 - m;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.fluid_io", IBlockSupplier.toString((IBlockSupplier)this.block), this.get(null) != null};
    }
}

