/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.container.ContainerItemBuffer;
import cd4017be.rs_ctr2.part.MultiBlock;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.ArrayUtils;

public class ItemBuffer
extends MultiBlock<ItemBuffer>
implements IInventoryAccess,
IUnnamedContainerProvider,
IPlayerPacketReceiver,
IItemHandler {
    ArrayDeque<ItemStack> inv = new ArrayDeque(1);
    int slots;
    int max;
    @Sync(to=-2147483648)
    public int n;
    @Sync(to=-2147483648, type=Sync.Type.I8)
    public int scroll;
    public static final ResourceLocation MODEL = Main.rl("part/item_buffer");

    public ItemBuffer(int pos) {
        super(pos);
    }

    public Item item() {
        return Content.item_buffer;
    }

    public Object getHandler(int port) {
        return this;
    }

    public void setHandler(int port, Object handler) {
    }

    public boolean isMaster(int port) {
        return false;
    }

    public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        rec = this.max - this.n;
        for (ItemStack stack : this.inv) {
            inspector.accept(stack, rec);
        }
        for (int i = this.slots - this.inv.size(); i > 0; --i) {
            inspector.accept(ItemStack.field_190927_a, rec);
        }
    }

    public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
        Iterator<ItemStack> it = this.inv.descendingIterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (!filter.test(stack)) continue;
            int n = stack.func_190916_E();
            int l = Math.min(n, amount);
            stack.func_190920_e(l);
            l = target.applyAsInt(stack);
            this.n -= l;
            if ((n -= l) <= 0) {
                it.remove();
            } else {
                stack.func_190920_e(n);
            }
            return l;
        }
        return 0;
    }

    public int insert(ItemStack stack, int rec) {
        int m = stack.func_190916_E();
        int l = Math.min(this.max - this.n, m);
        if (l <= 0) {
            return 0;
        }
        for (ItemStack stack1 : this.inv) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack)) continue;
            stack1.func_190917_f(l);
            this.n += l;
            return l;
        }
        if (this.inv.size() >= this.slots) {
            return 0;
        }
        this.inv.addFirst(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)l));
        this.n += l;
        return l;
    }

    public ItemBuffer setHost(IGridHost host) {
        ItemStack stack;
        super.setHost(host);
        if (host == null) {
            return this;
        }
        while (this.inv.size() > this.slots) {
            stack = this.inv.pollLast();
            this.n -= stack.func_190916_E();
            ItemFluidUtil.dropStack((ItemStack)stack, (World)host.world(), (BlockPos)host.pos());
        }
        while (this.n > this.max) {
            stack = this.inv.getLast();
            ItemStack stack1 = stack.func_77979_a(this.n - this.max);
            this.n -= stack1.func_190916_E();
            if (stack.func_190926_b()) {
                this.inv.pollLast();
            }
            ItemFluidUtil.dropStack((ItemStack)stack1, (World)host.world(), (BlockPos)host.pos());
        }
        return this;
    }

    @Override
    protected void onBoundsChange() {
        this.slots = Long.bitCount(this.bounds);
        this.max = this.slots * (Integer)Main.SERVER_CFG.item_buffer_size.get();
        this.setHost(this.host);
    }

    @Override
    public void loadState(CompoundNBT nbt, int mode) {
        if ((mode & 1) != 0) {
            this.n = 0;
            this.inv.clear();
            ListNBT list = nbt.func_150295_c("inv", 10);
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = ItemFluidUtil.loadItemHighRes((CompoundNBT)list.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                this.inv.addLast(stack);
                this.n += stack.func_190916_E();
            }
        }
        super.loadState(nbt, mode);
    }

    @Override
    public void storeState(CompoundNBT nbt, int mode) {
        if ((mode & 1) != 0) {
            ListNBT list = new ListNBT();
            for (ItemStack stack : this.inv) {
                list.add((Object)ItemFluidUtil.saveItemHighRes((ItemStack)stack));
            }
            nbt.func_218657_a("inv", (INBT)list);
        }
        super.storeState(nbt, mode);
    }

    @Override
    protected ActionResultType createPort(IGridItem item, short port, boolean client) {
        if (item != Content.item_cable) {
            return ActionResultType.PASS;
        }
        if (client) {
            return ActionResultType.CONSUME;
        }
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        this.ports = ArrayUtils.add((short[])this.ports, (short)((short)(port | 0x2000)));
        host.addPart((GridPart)this);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected ActionResultType onInteract(PlayerEntity player, boolean client) {
        if (client) {
            return ActionResultType.CONSUME;
        }
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this, pkt -> pkt.writeByte(this.slots).writeInt(this.max));
        return ActionResultType.SUCCESS;
    }

    @Override
    protected ItemBuffer splitOff(long splitBounds, long thisBounds) {
        ItemBuffer other = new ItemBuffer(-1);
        return other;
    }

    @Override
    protected short[] merge(ItemBuffer other) {
        this.max += other.max;
        this.slots += other.slots;
        for (ItemStack stack : other.inv) {
            this.insert(stack, 0);
        }
        return ArrayUtils.addAll((short[])this.ports, (short[])other.ports);
    }

    @Override
    protected ResourceLocation model() {
        return MODEL;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.item_buffer", this.n, this.max, this.inv.size(), this.slots};
    }

    public ContainerItemBuffer createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerItemBuffer(id, inv, this, this);
    }

    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        this.scroll = Math.max(0, Math.min(pkt.readUnsignedByte(), this.slots - 16));
    }

    public boolean dissassemble(World world, BlockPos pos) {
        ItemStack stack;
        while ((stack = this.inv.pollFirst()) != null) {
            ItemFluidUtil.dropStack((ItemStack)stack, (World)world, (BlockPos)pos);
        }
        return true;
    }

    public int getSlots() {
        return 16;
    }

    public ItemStack getStackInSlot(int slot) {
        if ((slot += this.scroll) >= this.inv.size()) {
            return ItemStack.field_190927_a;
        }
        for (ItemStack stack : this.inv) {
            if (--slot >= 0) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int m;
        block4: {
            if (!simulate) {
                int n = this.insert(stack, 0);
                return n == 0 ? stack : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - n));
            }
            m = stack.func_190916_E();
            int l = Math.min(this.max - this.n, m);
            if (l <= 0) {
                return stack;
            }
            m -= l;
            if (this.inv.size() >= this.slots) {
                for (ItemStack stack1 : this.inv) {
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack)) continue;
                    break block4;
                }
                return stack;
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)m);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if ((slot += this.scroll) >= this.inv.size()) {
            return ItemStack.field_190927_a;
        }
        Iterator<ItemStack> it = this.inv.iterator();
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (--slot >= 0) continue;
            amount = Math.min(amount, stack.func_190916_E());
            ItemStack stack1 = ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount);
            if (!simulate) {
                this.n -= amount;
                stack.func_190918_g(amount);
                if (stack.func_190926_b()) {
                    it.remove();
                }
            }
            return stack1;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.max;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return false;
    }
}

