/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.api.IProbeInfo;
import com.google.common.base.Predicates;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ItemDropper
extends OrientedPart
implements IInventoryAccess,
IBlockSupplier,
IProbeInfo {
    protected IBlockSupplier block = this;
    protected ImmutablePair<BlockPos, ServerWorld> last;
    float y;

    public ItemDropper() {
        super(2);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 4);
        this.setPort(1, pos, Direction.SOUTH, 2);
        int d = orient.b.func_96559_d();
        this.y = (float)(d != 0 ? d + 2 << 1 : this.ports[0] >> 4 & 0xF) * 0.125f;
    }

    public Item item() {
        return Content.item_dropper;
    }

    public Object getHandler(int port) {
        return port != 0 ? this : null;
    }

    public void setHandler(int port, Object handler) {
        if (port == 0) {
            this.block = IBlockSupplier.of((Object)handler, (IBlockSupplier)this);
            this.last = null;
        }
    }

    public boolean isMaster(int port) {
        return port == 0;
    }

    public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        ImmutablePair pos = this.block.getBlock();
        if (pos == null) {
            return;
        }
        for (ItemEntity ei : ((ServerWorld)pos.right).func_217394_a(EntityType.field_200765_E, new AxisAlignedBB((BlockPos)pos.left), (Predicate)Predicates.alwaysTrue())) {
            inspector.accept(ei.func_92059_d(), 0);
        }
    }

    public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
        ImmutablePair pos = this.block.getBlock();
        if (pos == null) {
            return 0;
        }
        int am0 = amount;
        for (ItemEntity ei : ((ServerWorld)pos.right).func_217394_a(EntityType.field_200765_E, new AxisAlignedBB((BlockPos)pos.left), e -> filter.test(e.func_92059_d()))) {
            ItemStack stack = ei.func_92059_d();
            int n = target.applyAsInt(stack.func_190916_E() <= amount ? stack : ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)amount));
            stack.func_190918_g(n);
            if (stack.func_190926_b()) {
                ((ServerWorld)pos.right).func_217467_h((Entity)ei);
            } else {
                ei.func_92058_a(stack);
            }
            if ((amount -= n) > 0) continue;
            break;
        }
        return am0 - amount;
    }

    public int insert(ItemStack stack, int rec) {
        ImmutablePair pos = this.block.getBlock();
        if (pos == null) {
            return 0;
        }
        BlockPos p = (BlockPos)pos.left;
        ItemEntity ei = new ItemEntity((World)pos.right, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + (double)this.y, (double)p.func_177952_p() + 0.5, stack.func_77946_l());
        ei.func_174869_p();
        ei.func_213317_d(Vector3d.field_186680_a);
        ((ServerWorld)pos.right).func_217376_c((Entity)ei);
        return stack.func_190916_E();
    }

    public ImmutablePair<BlockPos, ServerWorld> getBlock(int rec) {
        return this.last != null ? this.last : (this.onEdge() ? new ImmutablePair((Object)this.host.pos().func_177967_a(this.orient.b, -1), (Object)((ServerWorld)this.host.world())) : null);
    }

    @Override
    public Object[] stateInfo() {
        int[] n = new int[]{0};
        this.getContent((stack, cap) -> {
            n[0] = n[0] + stack.func_190916_E();
        });
        return new Object[]{"state.rs_ctr2.dropper", IBlockSupplier.toString((IBlockSupplier)this.block), n[0]};
    }
}

