/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.capability.BasicInventory;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.container.ContainerItemFilter;
import java.util.Arrays;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;

public class ItemFilter
extends OrientedPart
implements IInventoryAccess,
ISignalReceiver,
IGate,
Predicate<ItemStack>,
IUnnamedContainerProvider,
IProbeInfo {
    private final ItemStack[] items = new ItemStack[8];
    Item[] filter = new Item[0];
    IInventoryAccess main = IInventoryAccess.NOP;
    IInventoryAccess rem = IInventoryAccess.NOP;
    @Sync
    public byte val;
    @Sync(to=-2147483647)
    public byte idx;
    @Sync
    public boolean active;

    public ItemFilter() {
        super(4);
        Arrays.fill(this.items, ItemStack.field_190927_a);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 2);
        this.setPort(1, pos, Direction.WEST, 0);
        this.setPort(2, pos, Direction.EAST, 2);
        this.setPort(3, pos, Direction.SOUTH, 2);
    }

    public Item item() {
        return Content.item_filter;
    }

    public Object getHandler(int port) {
        return this.isMaster(port) ? null : this;
    }

    public void setHandler(int port, Object handler) {
        if (port == 2) {
            this.main = IInventoryAccess.of((Object)handler);
        } else if (port == 3) {
            this.rem = IInventoryAccess.of((Object)handler);
        }
    }

    public boolean isMaster(int port) {
        return port >= 2;
    }

    public void updateInput(int value, int rec) {
        this.val = (byte)value;
        if (this.val == this.val || this.active) {
            return;
        }
        this.active = true;
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    public boolean evaluate() {
        this.active = false;
        this.idx = this.val;
        return false;
    }

    private Predicate<ItemStack> filter() {
        if (this.idx >= 0) {
            if (this.idx >= this.items.length) {
                return null;
            }
            Item item = this.items[this.idx].func_77973_b();
            return stack -> stack.func_77973_b() == item;
        }
        return this.idx == -1 ? this : this.negate();
    }

    public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        if (--rec < 0) {
            return;
        }
        Predicate<ItemStack> filter = this.filter();
        if (filter == null) {
            this.rem.getContent(inspector, rec);
        } else {
            this.main.getContent((stack, n) -> {
                if (filter.test((ItemStack)stack)) {
                    inspector.accept((ItemStack)stack, n);
                }
            }, rec);
        }
    }

    public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
        if (--rec < 0) {
            return 0;
        }
        Predicate<ItemStack> filter0 = this.filter();
        return filter0 == null ? this.rem.transfer(amount, filter, target, rec) : this.main.transfer(amount, filter0.and(filter), target, rec);
    }

    public int insert(ItemStack stack, int rec) {
        if (--rec < 0) {
            return 0;
        }
        return (this.test(stack) ? this.main : this.rem).insert(stack, rec);
    }

    @Override
    public boolean test(ItemStack stack) {
        Item item = stack.func_77973_b();
        for (Item i : this.filter) {
            if (item != i) continue;
            return true;
        }
        return false;
    }

    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        if ((mode & 1) != 0) {
            ItemFluidUtil.loadInventory((ListNBT)nbt.func_150295_c("inv", 10), (ItemStack[])this.items);
            this.updateFilter(null, -1);
        }
    }

    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        if ((mode & 1) != 0) {
            nbt.func_218657_a("inv", (INBT)ItemFluidUtil.saveInventory((ItemStack[])this.items));
        }
    }

    private void updateFilter(ItemStack stack, int slot) {
        if (slot >= 0) {
            this.items[slot] = stack;
        }
        int m = 0;
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i].func_190926_b()) continue;
            m |= 1 << i;
        }
        int n = Integer.bitCount(m);
        if (this.filter.length != n) {
            this.filter = new Item[n];
        }
        n = 0;
        int i = 0;
        while (m != 0) {
            if ((m & 1) != 0) {
                this.filter[n++] = this.items[i].func_77973_b();
            }
            ++i;
            m >>>= 1;
        }
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        if (hand == null || player.func_213453_ef()) {
            return super.onInteract(player, hand, hit, pos);
        }
        if (player.field_70170_p.field_72995_K) {
            return ActionResultType.CONSUME;
        }
        player.func_213829_a((INamedContainerProvider)this);
        return ActionResultType.SUCCESS;
    }

    public ContainerItemFilter createMenu(int id, PlayerInventory pinv, PlayerEntity player) {
        BasicInventory inv = new BasicInventory(this.items);
        inv.onModify = this::updateFilter;
        return new ContainerItemFilter(id, pinv, inv, this);
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.item_filter", this.val, this.main != IInventoryAccess.NOP, this.rem != IInventoryAccess.NOP};
    }
}

