/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.port.IBlockSupplier;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.lib.network.Sync;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IProbeInfo;
import cd4017be.rs_ctr2.part.CapabilityIO;
import java.util.function.ObjIntConsumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ISidedInventoryProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class ItemIO
extends CapabilityIO<IItemHandler>
implements IInventoryAccess,
IGate,
IProbeInfo {
    @Sync
    public int in0 = 0;
    @Sync
    public int in1 = 255;
    @Sync
    public int s0 = 0;
    @Sync
    public int s1 = 255;
    @Sync
    public boolean active;

    public ItemIO() {
        super(4);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 4);
        this.setPort(1, pos, Direction.SOUTH, 2);
        this.setPort(2, pos, Direction.WEST, 0);
        this.setPort(3, pos, Direction.EAST, 0);
    }

    @Override
    protected Capability<IItemHandler> capability() {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public Item item() {
        return Content.item_io;
    }

    @Override
    public Object getHandler(int port) {
        switch (port) {
            case 1: {
                return this;
            }
            case 2: {
                return (v, r) -> {
                    this.in0 = v;
                    this.update(this.in0, this.in0);
                };
            }
            case 3: {
                return (v, r) -> {
                    this.in1 = v;
                    this.update(this.in1, this.in1);
                };
            }
        }
        return null;
    }

    private void update(int old, int val) {
        if (val != old && !this.active) {
            this.active = true;
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
    }

    @Override
    public GridPart setHost(IGridHost host) {
        if (this.active && host != null) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        return super.setHost(host);
    }

    public boolean evaluate() {
        this.active = false;
        this.s0 = Math.min(this.in0, this.in1);
        this.s1 = Math.max(this.in0, this.in1) + 1;
        return false;
    }

    @Override
    protected LazyOptional<IItemHandler> alternative(ImmutablePair<BlockPos, ServerWorld> src) {
        BlockState state = ((ServerWorld)src.right).func_180495_p((BlockPos)src.left);
        if (state.func_177230_c() instanceof ISidedInventoryProvider) {
            return LazyOptional.of(() -> {
                ISidedInventory inv = ((ISidedInventoryProvider)state.func_177230_c()).func_219966_a(state, (IWorld)src.right, (BlockPos)src.left);
                return inv == null ? EmptyHandler.INSTANCE : new SidedInvWrapper(inv, this.orient.b);
            });
        }
        return LazyOptional.empty();
    }

    public void getContent(ObjIntConsumer<ItemStack> inspector, int rec) {
        IItemHandler inv = this.get(EmptyHandler.INSTANCE);
        int l = Math.min(this.s1, inv.getSlots());
        for (int i = Math.max(this.s0, 0); i < l; ++i) {
            inspector.accept(inv.getStackInSlot(i), inv.getSlotLimit(i));
        }
    }

    public int transfer(int amount, Predicate<ItemStack> filter, ToIntFunction<ItemStack> target, int rec) {
        IItemHandler inv = this.get(EmptyHandler.INSTANCE);
        int l = Math.min(this.s1, inv.getSlots());
        for (int i = Math.max(this.s0, 0); i < l; ++i) {
            ItemStack stack1;
            int j;
            ItemStack stack = inv.extractItem(i, amount, true);
            int n = stack.func_190916_E();
            if (n <= 0 || !filter.test(stack)) continue;
            for (j = i + 1; j < l && n < amount; ++j) {
                stack1 = inv.extractItem(j, amount - n, true);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stack1)) continue;
                n += stack1.func_190916_E();
            }
            stack.func_190920_e(n);
            n = target.applyAsInt(stack);
            if (n <= 0) continue;
            amount = n;
            n -= inv.extractItem(i, n, false).func_190916_E();
            for (j = i + 1; j < l && n > 0; ++j) {
                stack1 = inv.getStackInSlot(j);
                if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)stack1)) continue;
                n -= inv.extractItem(j, n, false).func_190916_E();
            }
            if (n > 0) {
                Main.LOG.fatal("Missing {} of {} got duplicated, extracting from {}. Please report this bug!", (Object)n, (Object)stack, inv.getClass());
            }
            return amount;
        }
        return 0;
    }

    public int insert(ItemStack stack, int rec) {
        int l;
        IItemHandler inv = this.get(EmptyHandler.INSTANCE);
        int p = l = Math.min(this.s1, inv.getSlots());
        stack = stack.func_77946_l();
        int n = stack.func_190916_E();
        for (int i = Math.max(this.s0, 0); i < l; ++i) {
            if (inv.getStackInSlot(i).func_190926_b()) {
                p = Math.min(p, i);
                continue;
            }
            if (!(stack = inv.insertItem(i, stack, false)).func_190926_b()) continue;
            return n;
        }
        while (p < l) {
            if (inv.getStackInSlot(p).func_190926_b() && (stack = inv.insertItem(p, stack, false)).func_190926_b()) {
                return n;
            }
            ++p;
        }
        return n - stack.func_190916_E();
    }

    @Override
    public Object[] stateInfo() {
        IItemHandler inv = this.get(EmptyHandler.INSTANCE);
        return new Object[]{"state.rs_ctr2.item_io", IBlockSupplier.toString((IBlockSupplier)this.block), inv.getSlots(), this.in0, this.in1};
    }
}

