/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.port.IEnergyAccess;
import cd4017be.api.grid.port.IInventoryAccess;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.api.IProbeInfo;
import com.google.common.base.Predicates;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;

public class ItemMover
extends OrientedPart
implements ISignalReceiver,
IGate,
IProbeInfo {
    IInventoryAccess a = IInventoryAccess.NOP;
    IInventoryAccess b = IInventoryAccess.NOP;
    IEnergyAccess energy = IEnergyAccess.NOP;
    ISignalReceiver out = ISignalReceiver.NOP;
    @Sync
    public int num = 64;
    @Sync
    public int clk;
    @Sync
    public int res;
    @Sync
    public boolean active;

    public ItemMover() {
        super(6);
    }

    public void set(int pos, Orientation orient) {
        if ((pos & 0xC) == 12) {
            pos -= 4;
        }
        if ((pos & 0x30) == 48) {
            pos -= 16;
        }
        super.set(pos, orient);
        this.setBounds(pos, pos + 20);
        this.setPort(0, pos + 20, Direction.UP, 0);
        this.setPort(1, pos + 4, Direction.UP, 0);
        this.setPort(2, pos + 4, Direction.NORTH, 0);
        this.setPort(3, pos + 20, Direction.SOUTH, 1);
        this.setPort(4, pos + 0, Direction.NORTH, 2);
        this.setPort(5, pos + 16, Direction.SOUTH, 2);
    }

    public GridPart setHost(IGridHost host) {
        if (host != null && this.active) {
            GateUpdater.GATE_UPDATER.add((IGate)this);
        }
        return super.setHost(host);
    }

    public ISignalReceiver getHandler(int port) {
        return port == 1 ? (v, r) -> {
            this.num = v;
        } : (port == 0 ? this : null);
    }

    public void setHandler(int port, Object handler) {
        switch (port) {
            case 2: {
                this.out = ISignalReceiver.of((Object)handler);
                this.out.updateInput(this.res);
                break;
            }
            case 3: {
                this.energy = IEnergyAccess.of((Object)handler);
                break;
            }
            case 4: {
                this.a = IInventoryAccess.of((Object)handler);
                break;
            }
            case 5: {
                this.b = IInventoryAccess.of((Object)handler);
            }
        }
    }

    public boolean isMaster(int channel) {
        return channel >= 2;
    }

    public Item item() {
        return Content.item_mover;
    }

    public void updateInput(int value, int rec) {
        this.clk = value;
        if ((~this.clk & this.clk) == 0 || this.active) {
            return;
        }
        this.active = true;
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    public boolean evaluate() {
        this.active = false;
        if (this.host == null) {
            return false;
        }
        this.res = this.num;
        return (this.res | this.res) != 0;
    }

    public void latchOut() {
        if (this.res != 0) {
            int e = ItemMover.cost(this.res);
            if (this.energy.transferEnergy(e, true) != e) {
                this.res = 0;
            } else {
                this.res = this.res > 0 ? this.a.transfer(this.res, (Predicate)Predicates.alwaysTrue(), (ToIntFunction)this.b) : -this.b.transfer(-this.res, (Predicate)Predicates.alwaysTrue(), (ToIntFunction)this.a);
                this.energy.transferEnergy(ItemMover.cost(this.res), false);
            }
        }
        this.out.updateInput(this.res);
    }

    private static int cost(int am) {
        long e = (-1L - Math.abs((long)am)) * (long)((Integer)Main.SERVER_CFG.move_item.get()).intValue() >> 6;
        return e < -1073741824L ? -1073741824 : (int)e;
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.item_mover", this.clk, this.num, this.res, -this.energy.transferEnergy(-2147483647, true), this.a != IInventoryAccess.NOP, this.b != IInventoryAccess.NOP};
    }
}

