/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.IDynamicPart;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.render.GridModels;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.part.Switch;
import cd4017be.rs_ctr2.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LED
extends OrientedPart
implements IDynamicPart,
ISignalReceiver {
    @Sync(to=7)
    public boolean state;
    @Sync(to=7, type=Sync.Type.Enum)
    public DyeColor color = DyeColor.RED;
    public static final ResourceLocation LED = Main.rl("part/led");

    public LED() {
        super(1);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 0);
    }

    public Item item() {
        return Content.led;
    }

    public byte getLayer() {
        return -1;
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        if (hand == null) {
            return super.onInteract(player, hand, hit, pos);
        }
        DyeColor color = Utils.heldColor(player, hand);
        return color != null ? Utils.serverAction(player, () -> {
            this.color = color;
            this.host.onPartChange();
        }) : ActionResultType.PASS;
    }

    public Object getHandler(int port) {
        return this;
    }

    public void setHandler(int port, Object handler) {
    }

    public boolean isMaster(int port) {
        return false;
    }

    public void updateInput(int value, int rec) {
        this.state = value != 0;
        if (this.state ^ this.state && this.host != null) {
            this.host.updateDisplay();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected ResourceLocation model() {
        return Switch.BASE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack ms, IRenderTypeBuffer rtb, int light, int overlay, float t, long opaque) {
        if ((this.bounds & (opaque ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return;
        }
        ms.func_227860_a_();
        this.transform(ms);
        int color = this.color.func_218388_g() | 0xFF000000;
        GridModels.draw((ResourceLocation)LED, (MatrixStack.Entry)ms.func_227866_c_(), (IVertexBuilder)rtb.getBuffer(RenderType.func_228639_c_()), (int)(this.state ? color : color >> 2 & 0xFF3F3F3F), (int)(this.state ? 240 : light), (int)overlay);
        ms.func_227865_b_();
    }

    public void readSync(PacketBuffer pkt) {
        this.state = pkt.readBoolean();
    }

    public void writeSync(PacketBuffer pkt, boolean init) {
        pkt.writeBoolean(this.state);
    }
}

