/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.IDynamicPart;
import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.render.GridModels;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.part.ExtendablePart;
import cd4017be.rs_ctr2.part.LED;
import cd4017be.rs_ctr2.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LEDArray
extends ExtendablePart
implements IDynamicPart,
ISignalReceiver {
    @Sync(to=7)
    public byte state;
    @Sync(to=7, type=Sync.Type.Enum)
    public DyeColor color = DyeColor.RED;

    public LEDArray() {
        super(1);
    }

    @Override
    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setPort(0, pos + (pos >> 6 & 3), Direction.NORTH, 0);
    }

    public Item item() {
        return Content.led_array;
    }

    public byte getLayer() {
        return -1;
    }

    @Override
    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        DyeColor color = Utils.heldColor(player, hand);
        return color != null ? Utils.serverAction(player, () -> {
            this.color = color;
            this.host.onPartChange();
        }) : super.onInteract(player, hand, hit, pos);
    }

    public Object getHandler(int port) {
        return this;
    }

    public void setHandler(int port, Object handler) {
    }

    public boolean isMaster(int port) {
        return false;
    }

    public void updateInput(int value, int rec) {
        this.state = (byte)value;
        if (this.state != this.state && this.host != null) {
            this.host.updateDisplay();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected ResourceLocation model() {
        return Main.rl("part/switch_array" + (this.pos >> 6 & 3));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack ms, IRenderTypeBuffer rtb, int light, int overlay, float t, long opaque) {
        if ((this.bounds & (opaque ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return;
        }
        ms.func_227860_a_();
        this.transform(ms);
        int color = this.color.func_218388_g() | 0xFF000000;
        ms.func_227861_a_(-0.0625, 0.0, 0.0);
        IVertexBuilder vb = rtb.getBuffer(RenderType.func_228639_c_());
        for (int i = this.pos >> 5 & 6 | 1; i >= 0; --i) {
            boolean active = (this.state >> i & 1) != 0;
            GridModels.draw((ResourceLocation)LED.LED, (MatrixStack.Entry)ms.func_227866_c_(), (IVertexBuilder)vb, (int)(active ? color : color >> 2 & 0xFF3F3F3F), (int)(active ? 240 : light), (int)overlay);
            ms.func_227861_a_(0.125, 0.0, 0.0);
        }
        ms.func_227865_b_();
    }

    public void readSync(PacketBuffer pkt) {
        this.state = pkt.readByte();
    }

    public void writeSync(PacketBuffer pkt, boolean init) {
        pkt.writeByte((int)this.state);
    }
}

