/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.IDynamicPart;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.IPlayerPacketReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.render.MicroBlockFace;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.math.Linalg;
import cd4017be.math.MCConv;
import cd4017be.math.Orient;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.container.ContainerLabel;
import cd4017be.rs_ctr2.part.ExtendablePart;
import cd4017be.rs_ctr2.util.Utils;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Label
extends ExtendablePart
implements IDynamicPart,
IPlayerPacketReceiver,
IUnnamedContainerProvider {
    @Sync(to=-2147483641)
    public String text = "Label text";
    @Sync(to=7, type=Sync.Type.Enum)
    public DyeColor lc = DyeColor.WHITE;
    @Sync(to=7, type=Sync.Type.Enum)
    public DyeColor tc = DyeColor.BLACK;
    @OnlyIn(value=Dist.CLIENT)
    private int w;
    @OnlyIn(value=Dist.CLIENT)
    private int h;
    public static final ResourceLocation MODEL = Main.rl("part/label");

    public Label() {
        super(0);
    }

    public Item item() {
        return Content.label;
    }

    public byte getLayer() {
        return -1;
    }

    @Override
    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        ActionResultType ret = super.onInteract(player, hand, hit, pos);
        if (ret != ActionResultType.PASS) {
            return ret;
        }
        DyeColor color = Utils.heldColor(player, hand);
        return color != null ? Utils.serverAction(player, () -> {
            float[] vec = MCConv.blockRelVecF((Vector3d)hit.func_216347_e(), (BlockPos)hit.func_216350_a());
            if (Math.abs((vec = Orient.orient((int)this.orient.inv().o, (float[])Linalg.dadd((int)3, (float[])Linalg.subsca((int)3, (float[])vec, (float[])Label.vec((int)pos), (float)0.25f), (float)-0.125f)))[1]) < 0.0625f) {
                this.tc = color;
            } else {
                this.lc = color;
            }
            this.host.onPartChange();
        }) : (player.func_184586_b(hand).func_190926_b() ? Utils.serverAction(player, () -> player.func_213829_a((INamedContainerProvider)this)) : ActionResultType.PASS);
    }

    public Object getHandler(int port) {
        return null;
    }

    public void setHandler(int port, Object handler) {
    }

    public boolean isMaster(int port) {
        return false;
    }

    public void readSync(PacketBuffer pkt) {
    }

    public void writeSync(PacketBuffer pkt, boolean init) {
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateSize() {
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int w = 0;
        int h = 1;
        for (String line : this.text.split("\n", 4)) {
            fr.getClass();
            h += 9;
            w = Math.max(fr.func_78256_a(line), w);
        }
        this.w = w + 1;
        this.h = h;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillModel(JitBakedModel model, long opaque) {
        if ((this.bounds & (opaque ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return;
        }
        this.updateSize();
        float[] size = new float[]{(float)((this.pos >> 6 & 3) + 1) * 0.25f, 0.25f, 0.005f};
        float scale = Math.min((size[0] - 0.03125f) / (float)this.w, (size[1] - 0.03125f) / (float)this.h);
        float[] p = Linalg.sca((int)3, (float[])Label.vec((int)this.pos), (float)0.25f);
        float[] q = new float[]{(float)this.w * scale, (float)this.h * scale, size[2]};
        int o = this.orient.o;
        if ((o << 31 ^ o << 27 ^ o << 23) < 0) {
            q[0] = -q[0];
        }
        Linalg.add((int)3, (float[])p, (float[])Linalg.sca((int)3, (float[])Linalg.sub((int)3, (float[])size, (float[])q), (float)0.5f));
        p = Linalg.dadd((int)3, (float[])Orient.orient((int)o, (float[])Linalg.dadd((int)3, (float[])p, (float)-0.5f)), (float)0.5f);
        q = Orient.orient((int)o, (float[])q);
        ArrayList quads = model.inner();
        MicroBlockFace[] faces = MicroBlockFace.facesOf((Object)MODEL);
        int f = this.orient.b.ordinal();
        int c = Utils.RGBtoBGR(this.lc.getColorValue());
        quads.add(Utils.colorQuad(faces[f].makeRect(p, q), c));
        quads.add(Utils.colorQuad(faces[f ^ 1].makeRect(p, q), c));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack ms, IRenderTypeBuffer rtb, int light, int overlay, float t, long opaque) {
        ms.func_227860_a_();
        this.transform(ms);
        float scale = (float)((this.pos >> 6 & 3) + 1) * 0.25f;
        ms.func_227861_a_((double)(scale * 0.5f), 0.125, (double)0.01f);
        scale = Math.min((scale - 0.03125f) / (float)this.w, 0.21875f / (float)this.h);
        ms.func_227862_a_(scale, -scale, 1.0f);
        Matrix4f mat = ms.func_227866_c_().func_227870_a_();
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int c = this.tc.func_218388_g();
        float y = (float)this.h * -0.5f + 1.0f;
        for (String line : this.text.split("\n", 4)) {
            float x = (float)(1 - fr.func_78256_a(line)) * 0.5f;
            fr.func_228079_a_(line, x, y, c, false, mat, rtb, false, overlay, light);
            fr.getClass();
            y += 9.0f;
        }
        ms.func_227865_b_();
    }

    public void handlePlayerPacket(PacketBuffer pkt, ServerPlayerEntity sender) throws Exception {
        this.text = pkt.func_150789_c(256);
        this.host.onPartChange();
    }

    public ContainerLabel createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerLabel(id, inv, this);
    }
}

