/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.part.SignalGate;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.ArrayUtils;

public class MemRead
extends SignalGate
implements ISignalReceiver {
    int[] mem = ArrayUtils.EMPTY_INT_ARRAY;
    @Sync
    public int addr;
    @Sync
    public int bits = 32;

    public MemRead() {
        super(4);
    }

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.WEST, 0);
        this.setPort(1, pos, Direction.NORTH, 15);
        this.setPort(2, pos, Direction.EAST, 0);
        this.setPort(3, pos, Direction.SOUTH, 0);
    }

    public Item item() {
        return Content.mem_read;
    }

    public boolean evaluate() {
        this.active = false;
        if (this.host == null || this.bits == 0) {
            return false;
        }
        int p = this.addr * this.bits;
        int i = p >>> 5;
        this.state = i >= this.mem.length ? 0 : this.mem[i] >>> p & -1 >>> 32 - this.bits;
        return this.state != this.state;
    }

    public ISignalReceiver getHandler(int port) {
        return port == 3 ? this::updateBits : (port == 2 ? this : null);
    }

    @Override
    public void setHandler(int port, Object handler) {
        if (port == 1) {
            this.mem = handler instanceof int[] ? (int[])handler : ArrayUtils.EMPTY_INT_ARRAY;
        } else {
            super.setHandler(port, handler);
        }
    }

    @Override
    public boolean isMaster(int channel) {
        return channel < 2;
    }

    public void updateBits(int value, int rec) {
        this.bits = value;
        if (this.bits != this.bits) {
            this.update();
        }
    }

    public void updateInput(int value, int rec) {
        this.addr = value;
        if (this.addr != this.addr) {
            this.update();
        }
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.mem_read", this.state, this.mem.length << 5, this.addr, this.bits};
    }
}

