/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.lib.part.OrientedPart;
import cd4017be.lib.tick.GateUpdater;
import cd4017be.lib.tick.IGate;
import cd4017be.lib.util.Orientation;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.api.IProbeInfo;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.ArrayUtils;

public class MemWrite
extends OrientedPart
implements IGate,
ISignalReceiver,
IProbeInfo {
    int[] mem = ArrayUtils.EMPTY_INT_ARRAY;
    int idx;
    int val;
    @Sync
    public int addr;
    @Sync
    public int bits;
    @Sync
    public int state;
    @Sync
    public boolean active;

    public void set(int pos, Orientation orient) {
        super.set(pos, orient);
        this.setBounds(pos, pos);
        this.setPort(0, pos, Direction.NORTH, 15);
        this.setPort(1, pos, Direction.WEST, 0);
        this.setPort(2, pos, Direction.EAST, 0);
        this.setPort(3, pos, Direction.SOUTH, 0);
    }

    public MemWrite() {
        super(4);
    }

    public Item item() {
        return Content.mem_write;
    }

    public ISignalReceiver getHandler(int port) {
        return port == 1 ? (v, r) -> {
            this.state = v;
            this.update(this.state, this.state);
        } : (port == 3 ? (v, r) -> {
            this.bits = v;
            this.update(this.bits, this.bits);
        } : (port == 2 ? this : null));
    }

    public void setHandler(int port, Object handler) {
        if (port == 0) {
            this.mem = handler instanceof int[] ? (int[])handler : ArrayUtils.EMPTY_INT_ARRAY;
        }
    }

    public boolean isMaster(int port) {
        return port == 0;
    }

    public boolean evaluate() {
        this.active = false;
        if (this.host == null || this.bits == 0) {
            return false;
        }
        int p = this.addr * this.bits;
        this.idx = p >>> 5;
        if (this.idx >= this.mem.length) {
            return false;
        }
        int m = -1 >>> 32 - this.bits << p;
        this.val = this.state << p & m | this.mem[this.idx] & ~m;
        return true;
    }

    public void latchOut() {
        if (this.idx < this.mem.length) {
            this.mem[this.idx] = this.val;
        }
    }

    public void updateInput(int value, int rec) {
        this.addr = value;
        this.update(this.addr, this.addr);
    }

    private void update(int old, int val) {
        if (old == val || this.active) {
            return;
        }
        this.active = true;
        GateUpdater.GATE_UPDATER.add((IGate)this);
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.mem_write", this.mem.length << 5, this.state, this.addr, this.bits};
    }
}

