/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.lib.container.IUnnamedContainerProvider;
import cd4017be.lib.network.Sync;
import cd4017be.rs_ctr2.Content;
import cd4017be.rs_ctr2.Main;
import cd4017be.rs_ctr2.container.ContainerMemory;
import cd4017be.rs_ctr2.part.MultiBlock;
import java.util.Arrays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;

public class Memory
extends MultiBlock<Memory>
implements IUnnamedContainerProvider {
    @Sync
    public int[] data;
    public static final ResourceLocation MODEL = Main.rl("part/memory");

    public Memory(int pos) {
        super(pos);
    }

    public Item item() {
        return Content.memory;
    }

    public Object getHandler(int port) {
        return this.data;
    }

    public void setHandler(int port, Object handler) {
    }

    public boolean isMaster(int port) {
        return false;
    }

    @Override
    protected void onBoundsChange() {
        int l = Long.bitCount(this.bounds) * ((Integer)Main.SERVER_CFG.memory_size.get() >> 5);
        if (this.data == null) {
            this.data = new int[l];
        } else if (l != this.data.length) {
            this.data = Arrays.copyOf(this.data, l);
            if (this.host != null) {
                this.host.removePart((GridPart)this);
            }
        }
    }

    private boolean isMemory(IGridItem item) {
        return item == Content.mem_read || item == Content.mem_write;
    }

    @Override
    protected ActionResultType createPort(IGridItem item, short port, boolean client) {
        if (!this.isMemory(item)) {
            return ActionResultType.PASS;
        }
        if (client) {
            return ActionResultType.CONSUME;
        }
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        this.ports = ArrayUtils.add((short[])this.ports, (short)((short)(port | 0xF000)));
        host.addPart((GridPart)this);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected ActionResultType onInteract(PlayerEntity player, boolean client) {
        if (client) {
            return ActionResultType.CONSUME;
        }
        player.func_213829_a((INamedContainerProvider)this);
        return ActionResultType.SUCCESS;
    }

    @Override
    protected Memory splitOff(long splitBounds, long thisBounds) {
        return new Memory(-1);
    }

    @Override
    protected short[] merge(Memory other) {
        if (other.data.length > this.data.length) {
            this.data = other.data;
        }
        return ArrayUtils.addAll((short[])this.ports, (short[])other.ports);
    }

    @Override
    protected ResourceLocation model() {
        return MODEL;
    }

    public ContainerMemory createMenu(int id, PlayerInventory inv, PlayerEntity player) {
        return new ContainerMemory(id, inv, this);
    }

    @Override
    public Object[] stateInfo() {
        return new Object[]{"state.rs_ctr2.memory", this.data.length << 5};
    }
}

