/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.GridPart;
import cd4017be.api.grid.IGridHost;
import cd4017be.api.grid.IGridItem;
import cd4017be.lib.render.GridModels;
import cd4017be.lib.render.MicroBlockFace;
import cd4017be.lib.render.model.JitBakedModel;
import cd4017be.lib.util.ItemFluidUtil;
import cd4017be.rs_ctr2.api.IProbeInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.ArrayUtils;

public abstract class MultiBlock<T extends MultiBlock<T>>
extends GridPart
implements IProbeInfo {
    public MultiBlock(int pos) {
        super(0);
        if (pos < 0) {
            return;
        }
        this.bounds = 1L << pos;
        this.onBoundsChange();
    }

    public ItemStack asItemStack() {
        return new ItemStack((IItemProvider)this.item(), Long.bitCount(this.bounds));
    }

    public ActionResultType onInteract(PlayerEntity player, Hand hand, BlockRayTraceResult hit, int pos) {
        boolean client = player.field_70170_p.field_72995_K;
        if (hand == null) {
            if (client || !(player.func_184614_ca().func_77973_b() instanceof IGridItem)) {
                return ActionResultType.CONSUME;
            }
            this.removeVoxel(pos);
            if (!player.func_184812_l_()) {
                ItemFluidUtil.dropStack((ItemStack)super.asItemStack(), (Entity)player);
            }
            return ActionResultType.CONSUME;
        }
        Item item = player.func_184586_b(hand).func_77973_b();
        short port = MultiBlock.port((int)pos, (Direction)hit.func_216354_b(), (int)0);
        int p = this.findPort(port);
        if (item instanceof IGridItem) {
            return p >= 0 ? ActionResultType.PASS : this.createPort((IGridItem)item, port, client);
        }
        if (!player.func_225608_bj_()) {
            return this.onInteract(player, client);
        }
        if (item != Items.field_190931_a) {
            return ActionResultType.PASS;
        }
        if (client) {
            return ActionResultType.CONSUME;
        }
        if (p < 0) {
            return ActionResultType.FAIL;
        }
        IGridHost host = this.host;
        host.removePart((GridPart)this);
        this.ports = ArrayUtils.remove((short[])this.ports, (int)p);
        host.addPart((GridPart)this);
        return ActionResultType.SUCCESS;
    }

    protected ActionResultType onInteract(PlayerEntity player, boolean client) {
        return ActionResultType.PASS;
    }

    private int findPort(int port) {
        port &= 0xFFF;
        for (int i = 0; i < this.ports.length; ++i) {
            if ((this.ports[i] & 0xFFF) != port) continue;
            return i;
        }
        return -1;
    }

    private static int portValid(short port, long b) {
        int p = IGridHost.posOfport((int)port);
        int q = IGridHost.posOfport((int)(port - 273));
        return ~p >>> 31 & (int)(b >>> p) ^ ~q >>> 31 & (int)(b >>> q);
    }

    public void setBounds(long b) {
        long valid = 0L;
        for (int i = 0; i < this.ports.length; ++i) {
            valid |= (long)MultiBlock.portValid(this.ports[i], b) << i;
        }
        int n = Long.bitCount(valid);
        IGridHost host = this.host;
        if (n >= this.ports.length) {
            this.bounds = b;
            this.onBoundsChange();
            if (host == null) {
                return;
            }
            host.updateBounds();
            host.onPartChange();
            return;
        }
        if (host != null) {
            host.removePart((GridPart)this);
        }
        short[] arr = new short[n];
        int i = 0;
        int j = 0;
        while (valid != 0L) {
            if ((valid & 1L) != 0L) {
                arr[j++] = this.ports[i];
            }
            ++i;
            valid >>>= 1;
        }
        this.ports = arr;
        this.bounds = b;
        this.onBoundsChange();
        if (host != null) {
            host.addPart((GridPart)this);
        }
    }

    public void removeVoxel(int pos) {
        long b = this.bounds & (1L << pos ^ 0xFFFFFFFFFFFFFFFFL);
        IGridHost host = this.host;
        if (b == 0L) {
            this.dissassemble(host.world(), host.pos());
            host.removePart((GridPart)this);
            host.removeIfEmpty();
            return;
        }
        long b1 = MultiBlock.floodFill((long)b, (long)Long.lowestOneBit(b));
        if (b1 != b) {
            host.removePart((GridPart)this);
            do {
                T part = this.splitOff(b1, b);
                ((MultiBlock)part).ports = this.ports;
                ((MultiBlock)part).setBounds(b1);
                host.addPart(part);
            } while ((b1 = MultiBlock.floodFill((long)(b &= b1 ^ 0xFFFFFFFFFFFFFFFFL), (long)Long.lowestOneBit(b))) != b);
        }
        this.setBounds(b);
        host.addPart((GridPart)this);
    }

    public T findAdjacent(IGridHost host, long b) {
        long o = MultiBlock.outline((long)b) & (b ^ 0xFFFFFFFFFFFFFFFFL);
        Class<?> c = this.getClass();
        return (T)((MultiBlock)host.findPart(p -> (p.bounds & o) != 0L && p.getClass() == c));
    }

    public boolean addVoxel(int pos) {
        T part;
        if (this.host.getPart(pos, (byte)0) != null) {
            return false;
        }
        long b = this.bounds | 1L << pos;
        IGridHost host = this.host;
        while ((part = this.findAdjacent(host, b)) != null) {
            host.removePart(part);
            b |= ((MultiBlock)part).bounds;
            short[] p = this.merge(part);
            if (p == this.ports) continue;
            host.removePart((GridPart)this);
            this.ports = p;
        }
        this.setBounds(b);
        host.addPart((GridPart)this);
        return true;
    }

    public void loadState(CompoundNBT nbt, int mode) {
        super.loadState(nbt, mode);
        this.bounds = nbt.func_74763_f("b");
        this.onBoundsChange();
        int[] arr = nbt.func_74759_k("p");
        this.ports = new short[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            this.ports[i] = (short)arr[i];
        }
    }

    public void storeState(CompoundNBT nbt, int mode) {
        super.storeState(nbt, mode);
        nbt.func_74772_a("b", this.bounds);
        int[] arr = new int[this.ports.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.ports[i];
        }
        nbt.func_74783_a("p", arr);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillModel(JitBakedModel model, long opaque) {
        MicroBlockFace.drawVoxels((JitBakedModel)model, (Object)this.model(), (long)this.bounds, (long)opaque);
        for (int i = 0; i < this.ports.length; ++i) {
            short port = this.ports[i];
            GridModels.drawPort((JitBakedModel)model, (short)port, (boolean)this.isMaster(i), (long)this.bounds, (long)opaque);
        }
    }

    protected abstract void onBoundsChange();

    protected abstract ActionResultType createPort(IGridItem var1, short var2, boolean var3);

    protected abstract T splitOff(long var1, long var3);

    protected abstract short[] merge(T var1);

    protected abstract ResourceLocation model();

    public boolean canRotate() {
        return true;
    }

    public void rotate(int steps) {
        MultiBlock.rotate((short[])this.ports, (int)steps);
        super.rotate(steps);
    }

    public boolean canMove(Direction d, int n) {
        long m = MultiBlock.mask((int)d.ordinal(), (int)n);
        return (this.bounds & m) == 0L || (this.bounds & (m ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public GridPart move(Direction d, int n) {
        GridPart part = super.move(d, n);
        MultiBlock.move((short[])this.ports, (Direction)d, (int)n, (part != null ? 1 : 0) != 0);
        return part;
    }
}

