/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.rs_ctr2.part;

import cd4017be.api.grid.port.ISignalReceiver;
import cd4017be.lib.network.Sync;
import cd4017be.rs_ctr2.part.SignalGate;

public abstract class MultiInputGate
extends SignalGate {
    @Sync
    public final int[] in;

    public MultiInputGate(int inputs) {
        super(inputs + 1);
        this.in = new int[inputs];
    }

    public ISignalReceiver getHandler(int port) {
        if (port == 0 || port > this.in.length) {
            return null;
        }
        int i = port - 1;
        return (v, r) -> {
            if (v == this.in[i]) {
                return;
            }
            this.in[i] = v;
            this.update();
        };
    }

    protected String info() {
        return "state.rs_ctr2.gate" + this.in.length;
    }

    @Override
    public Object[] stateInfo() {
        Object[] args = new Object[this.in.length + 2];
        args[0] = this.info();
        args[1] = this.state;
        for (int i = 0; i < this.in.length; ++i) {
            args[i + 2] = this.in[i];
        }
        return args;
    }
}

